<?php
require_once __DIR__ . "/../models/Empresa.php";

function validarRut($rutCompleto) {
    // Verificar formato: dígitos + guión + dígito verificador (0-9 o k/K)
    if (!preg_match('/^[0-9]+[-|‐]{1}[0-9kK]{1}$/', $rutCompleto)) {
        return false;
    }

    // Separar número y dígito verificador
    list($rut, $digv) = explode('-', $rutCompleto);

    // Calcular dígito verificador
    $M = 0;
    $S = 1;
    for ($T = $rut; $T > 0; $T = floor($T / 10)) {
        $S = ($S + ($T % 10) * (9 - $M++ % 6)) % 11;
    }
    $dvCalculado = $S ? $S - 1 : 'k';

    // Comparar dígito verificador (ignorar mayúsculas/minúsculas)
    return $dvCalculado == strtolower($digv);
}
class EmpresaController{
    private $empresaModel;
    private $userModel;
    private $dataErrors = [];
    private $header;

    public function __construct($mysqli,$header){
        $this->empresaModel = new Empresa($mysqli,$header);
        $this->header = $header;
    }

    public function resumenGeneral(){
        try {
            if($this->header['profile'] !='SUPERADMIN') throw new Exception('E401');           
            $resumen = $this->empresaModel->resumenGeneral();
            if(!$resumen) throw new Exception("E404");
            $resp = $this->formateaResumenGeneral($resumen);
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");   
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }public function resumen(){
        try {
            if($this->header['profile'] !='SUPERADMIN') throw new Exception('E401');            
            if($resumen = $this->empresaModel->resumen()) ApiResponse::success('S001',$resumen); throw new Exception('E404');   
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function listarEmpresas(){
        try {
            if($this->header['profile'] !='SUPERADMIN') throw new Exception('E401');   
            if($business = $this->empresaModel->getAllListBusiness()) ApiResponse::success('S001',$business); throw new Exception('E404');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function listarEmpresasActivas(){
        try {
            if($this->header['profile'] !='SUPERADMIN') throw new Exception('E401');
            if($business = $this->empresaModel->getActiveListBusiness()) ApiResponse::success('S001',$business); throw new Exception('E404');
        } catch (Exception $e) {
             ApiResponse::error($e->getMessage());
        }
    }
    public function listarTipoOrganizacion(){
        try {
            if($this->header['profile'] !='SUPERADMIN') throw new Exception('E401');   
            if($business = $this->empresaModel->getAllOrganizationType()) ApiResponse::success('S001',$business); throw new Exception('E404');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function crearEmpresa($data){
        try {
            if($this->header['profile'] !='SUPERADMIN') throw new Exception('E401');
            if(!validarRut($data['rut'].'-'.$data['dv'])) $dataErrors[] = array("rut y dv son incorrectos");
            if(!validarRut($data['rut_representante'].'-'.$data['dv_representante'])) $dataErrors[] = array("rut_representante y dv_representante son incorrectos");
            if(isset($dataErrors)) ApiResponse::error('E400',$dataErrors);
            $idBusiness = $this->empresaModel->createOrganization($data['rut'],$data['dv'],$data['nombre'],$data['direccion'],$data['id_comuna'],$data      ['rut_representante'],$data['dv_representante'],$data['representante_legal'],$data['email_representante_legal'],$data   ['telefono_representante_legal'],$data['fecha_inicio_operacion'],$data['fecha_termino_operacion'],$data['id_tipo_organizacion']);
            if($idBusiness) ApiResponse::success('S002',$idBusiness); throw new Exception('E500');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function actualizarEmpresa($id,$data){
        try {
            $modParam['nombre'] = NULL;
            $modParam['direccion'] = NULL;
            $modParam['id_comuna'] = NULL;
            $modParam['rut_representante'] = NULL;
            $modParam['dv_representante'] = NULL;
            $modParam['representante_legal'] = NULL;
            $modParam['telefono_representante_legal'] = null;
            $modParam['fecha_inicio_operacion'] = null;
            $modParam['fecha_termino_operacion'] = null;
            $modParam['id_tipo_organizacion'] = null;
            $modParam['estado'] = null;
            $modParam['email_representante_legal'] = null;

            if(isset($data['rut_representante']) && isset($data['dv_representante'])){
                if(!validarRut($data['rut_representante'].'-'.$data['dv_representante'])) $dataErrors[] = array("rut_representante y dv_representante son incorrectos");
                $modParam['rut_representante'] = $data['rut_representante'];
                $modParam['dv_representante'] = $data['dv_representante'];
            }
            if(isset($dataErrors)) ApiResponse::error('E400',$dataErrors);
            
            if(isset($data['nombre'])) $modParam['nombre'] = $data['nombre'];
            if(isset($data['direccion'])) $modParam['direccion'] = $data['direccion'];
            if(isset($data['id_comuna'])) $modParam['id_comuna'] = $data['id_comuna'];
            if(isset($data['representante_legal'])) $modParam['representante_legal'] = $data['representante_legal'];
            if(isset($data['telefono_representante_legal'])) $modParam['telefono_representante_legal'] = $data['telefono_representante_legal'];
            if(isset($data['fecha_inicio_operacion'])) $modParam['fecha_inicio_operacion'] = $data['fecha_inicio_operacion'];
            if(isset($data['fecha_termino_operacion'])) $modParam['fecha_termino_operacion'] = $data['fecha_termino_operacion'];
            if(isset($data['estado'])) $modParam['estado'] = $data['estado'];
            if(isset($data['email_representante_legal'])) $modParam['email_representante_legal'] = $data['email_representante_legal'];
            if(isset($data['id_tipo_organizacion'])) $modParam['id_tipo_organizacion'] = $data['id_tipo_organizacion']; 
            
            $affected_rows = 0;
            switch($this->header['profile']){
                case 'SUPERADMIN':
                    $affected_rows = $this->empresaModel->updateOrganizationById($id,$modParam); // actualiza la empresa solicitada, no se valida la empresa que realiza la solicitud dado que el SUPERADMIN controla todas las organizaciones del sistema.
                    break;
                case 'ADMIN':
                    if($this->header['Business-Id']!=$id) throw new Exception('E401');
                    //se limpian los datos que el administrador no puede modificar por si estos son incluidos en la llamada
                    $modParam['fecha_inicio_operacion'] = null;
                    $modParam['fecha_termino_operacion'] = null;
                    $modParam['id_tipo_organizacion'] = null;
                    $modParam['estado'] = null;
                    
                    $affected_rows = $this->empresaModel->updateOrganizationById($id,$modParam);
                    break;
                default:
                    throw new Exception('E401');
                    break;
            }
            if ($affected_rows > 0) ApiResponse::success('S003',$id); throw new Exception('E406');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function deleteEmpresa($id){
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception('E401');
            $affected_rows = $this->empresaModel->deleteOrganizationById($id);
            if ($affected_rows > 0) ApiResponse::success('S003',$id); throw new Exception('E406');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
        
    }
    public function bloquearEmpresa($id){
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception('E401');
            $affected_rows = $this->empresaModel->bloquearEmpresa($id);
            if ($affected_rows > 0) ApiResponse::success('S003',$id); throw new Exception('E406');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
        
    }
    public function crearTipoEmpresa($data){
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception('E401');
            if($type = $this->empresaModel->getOrganizationType($data['tipo_organizacion'])) throw new Exception('E505');
            
            if($idTypeBusiness = $this->empresaModel->createTypeOrganization($data['tipo_organizacion'])) ApiResponse::success('S005',$idTypeBusiness); throw new Exception('E500');  
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function actualizarTipoOrganizacion($id,$data){
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception('E401');
            $affected_rows = $this->empresaModel->updateOrganizationType($id,$data['tipo_organizacion']);
            if($affected_rows > 0) ApiResponse::success('S006',$id); throw new Exception('E406');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function deleteTipoEmpresa($id){
        try {
            if($this->header['profile'] != 'SUPERADMIN') throw new Exception('E401');
            if($this->empresaModel->getUseOrganiationType($id)) throw new Exception('E504');
            
            $affected_rows = $this->empresaModel->deleteOrganizationTypeById($id);
            var_dump($affected_rows);
            if ($affected_rows > 0) ApiResponse::success('S007',$id); throw new Exception('E406');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
        
    }
    private function formateaResumenGeneral($data){
        // Orden deseado de estados
        $order = ["TOTAL", "ACTIVO", "INACTIVO", "BLOQUEADO", "ELIMINADO"];

        // 1) Agrupar por tipo
        $grouped = [];
        foreach ($data as $row) {
            $tipo   = $row['tipo'];
            $estado = $row['estado'];
            $total  = (int)$row['total'];
        
            if (!isset($grouped[$tipo])) {
                $grouped[$tipo] = [];
            }
            // guardamos por estado para poder ordenar después
            $grouped[$tipo][$estado] = ['estado' => $estado, 'total' => $total];
        }

        // 2) Construir salida con estructura requerida y orden de estados
        $output = [];
        foreach ($grouped as $tipo => $estadosMap) {
            $detalle = [];
        
            // respetar el orden predefinido; incluir solo los estados presentes
            foreach ($order as $estadoDeseado) {
                if (isset($estadosMap[$estadoDeseado])) {
                    $detalle[] = $estadosMap[$estadoDeseado];
                }
            }
        
            // por si aparece algún estado no previsto en $order
            foreach ($estadosMap as $estado => $item) {
                if (!in_array($estado, $order, true)) {
                    $detalle[] = $item;
                }
            }
        
            $output[] = [
                'area'    => $tipo,
                'detalle' => $detalle
            ];
        }
        return $output;
    }





}