<?php
class Empresa{
    private $mysqli;
    private $header;

    public function __construct($mysqli,$header){
        $this->mysqli = $mysqli;
        $this->mysqli->set_charset("utf8mb4");
        $this->header = $header;
    }
    public function resumenGeneral(){
        $sql = "CALL sp_resumen_general();";
        $resp = $this->executeSelectQuery($sql);
        return $resp;
    }
    public function resumen(){
        $sql = "CALL sp_obtener_resumen_empresas();";
        $resp = $this->executeSelectQuery($sql);
        return $resp;
    }
    public function getAllListBusiness(){
        
        $sql = "SELECT _e.id,
            _e.rut AS rut_empresa,
            _e.dv as dv_empresa,
            _e.nombre AS nombre_empresa,
            _e.direccion AS direccion_empresa,
            _e.rut_representante,
            _e.dv_representante,
            _e.representante_legal AS nombre_representante,
            _e.email_representante_legal AS email_representante,
            _e.telefono_representante_legal AS telefono_representante,
            _e.fecha_inicio_operacion AS fecha_oper_ini,
            _e.fecha_termino_operacion AS fecha_oper_fin,
            _e.estado,
            _e.fecha_creacion,
            _e.id_tipo_organizacion,
            _t.tipo AS tipo_organizacion,
            _e.id_comuna,
            _c.nombre AS comuna,
            _c.idProvincia AS id_provincia,
            _p.nombre AS provincia,
            _p.idRegion AS id_region,
            _r.nombre AS region
            FROM __empresa _e 
            LEFT JOIN __tipo_organizacion _t ON _e.id_tipo_organizacion = _t.id
            LEFT JOIN __comuna _c ON _e.id_comuna = _c.id
            LEFT JOIN __provincia _p ON _c.idProvincia = _p.id
            LEFT JOIN __region _r ON _p.idRegion = _r.id
			WHERE _e.estado IN ('ACTIVO','BLOQUEADO')
            ORDER BY fecha_creacion desc";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $dataBusiness[] = $row;
        }
        $stmt->close();
        return $dataBusiness ?? [];
    }
    public function getActiveListBusiness(){
        $sql = "SELECT _e.id,
            _e.rut AS rut_empresa,
            _e.dv as dv_empresa,
            _e.nombre AS nombre_empresa,
            _e.direccion AS direccion_empresa,
            _e.rut_representante,
            _e.dv_representante,
            _e.representante_legal AS nombre_representante,
            _e.email_representante_legal AS email_representante,
            _e.telefono_representante_legal AS telefono_representante,
            _e.fecha_inicio_operacion AS fecha_oper_ini,
            _e.fecha_termino_operacion AS fecha_oper_fin,
            _e.estado,
            _e.fecha_creacion,
            _e.id_tipo_organizacion,
            _t.tipo AS tipo_organizacion,
            _e.id_comuna,
            _c.nombre AS comuna,
            _c.idProvincia AS id_provincia,
            _p.nombre AS provincia,
            _p.idRegion AS id_region,
            _r.nombre AS region
            FROM __empresa _e 
            LEFT JOIN __tipo_organizacion _t ON _e.id_tipo_organizacion = _t.id
            LEFT JOIN __comuna _c ON _e.id_comuna = _c.id
            LEFT JOIN __provincia _p ON _c.idProvincia = _p.id
            LEFT JOIN __region _r ON _p.idRegion = _r.id 
            WHERE _e.estado = 'ACTIVO' ORDER BY _e.fecha_creacion desc";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $dataBusiness[] = $row;
        }
        $stmt->close();
        return $dataBusiness ?? [];
    }
    public function getAllOrganizationType(){
        $sql = "SELECT id, tipo FROM __tipo_organizacion;";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
        $stmt->close();
        return $data ?? [];
    }
    public function createOrganization($rut,$dv,$nombre,$direccion,$id_comuna,$rut_representante,$dv_representante,$representante_legal,$email_representante_legal,$telefono_representante_legal,$fecha_inicio_operacion,$fecha_termino_operacion,$id_tipo_organizacion){
        $sql = "INSERT INTO __empresa (rut,dv,nombre,direccion,id_comuna,rut_representante,dv_representante,representante_legal,email_representante_legal,telefono_representante_legal,fecha_inicio_operacion,fecha_termino_operacion,id_tipo_organizacion)VALUE (?,?,?,?,?,?,?,?,?,?,?,?,?);";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->bind_param("isssiissssssi", $rut,$dv,$nombre,$direccion,$id_comuna,$rut_representante,$dv_representante,$representante_legal,$email_representante_legal,$telefono_representante_legal,$fecha_inicio_operacion,$fecha_termino_operacion,$id_tipo_organizacion);
        if (!$stmt->execute()) {
            throw new Exception('E503');
        }
        $id = $this->mysqli->insert_id;
        $stmt->close();
        return $id;
    }
    public function bloquearEmpresa($id){
        $sql = "CALL sp_bloquear_empresa(?, @p_rows_affected);";
        $types = "i";
        $values = array($id);
        $resp = $this->executeProcedureUpdate($sql,$types,$values);
        return $resp;
    }
    public function updateOrganizationById($id,$modParam){
        $sql = "UPDATE __empresa SET ";
        $params = [];
        $types = "";
        $values = [];
        if ($modParam['nombre'] !== null) {
            $sql .= "nombre = ?, ";
            $types .= "s";
            $values[] = $modParam['nombre'];
        }
        if ($modParam['direccion'] !== null) {
            $sql .= "direccion = ?, ";
            $types .= "s";
            $values[] = $modParam['direccion'];
        }
        if ($modParam['id_comuna'] !== null) {
            $sql .= "id_comuna = ?, ";
            $types .= "i";
            $values[] = $modParam['id_comuna'];
        }
        if ($modParam['rut_representante'] !== null) {
            $sql .= "rut_representante = ?, ";
            $types .= "i";
            $values[] = $modParam['rut_representante'];
        }
        if ($modParam['dv_representante'] !== null) {
            $sql .= "dv_representante = ?, ";
            $types .= "s";
            $values[] = $modParam['dv_representante'];
        }
        if ($modParam['representante_legal'] !== null) {
            $sql .= "representante_legal = ?, ";
            $types .= "s";
            $values[] = $modParam['representante_legal'];
        }
        if ($modParam['telefono_representante_legal'] !== null) {
            $sql .= "telefono_representante_legal = ?, ";
            $types .= "s";
            $values[] = $modParam['telefono_representante_legal'];
        }
        if ($modParam['fecha_inicio_operacion'] !== null) {
            $sql .= "fecha_inicio_operacion = ?, ";
            $types .= "s";
            $values[] = $modParam['fecha_inicio_operacion'];
        }
        if ($modParam['fecha_termino_operacion'] !== null) {
            $sql .= "fecha_termino_operacion = ?, ";
            $types .= "s";
            $values[] = $modParam['fecha_termino_operacion'];
        }
        if ($modParam['id_tipo_organizacion'] !== null) {
            $sql .= "id_tipo_organizacion = ?, ";
            $types .= "i";
            $values[] = $modParam['id_tipo_organizacion'];
        }
        if ($modParam['email_representante_legal'] !== null) {
            $sql .= "email_representante_legal = ?, ";
            $types .= "i";
            $values[] = $modParam['email_representante_legal'];
        }
        if ($modParam['estado'] !== null) {
            $sql .= "estado = ?, ";
            $types .= "s";
            $values[] = $modParam['estado'];
        }

        $modParam['nombre'] = NULL;

        $types .= "i"; // Para evaluationId
        $values[] = $id;
        $sql = rtrim($sql, ", ") . " WHERE id = ?";

        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->bind_param($types, ...$values);
        if (!$stmt->execute()) {
            throw new Exception('E502');
        }
        $affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $affected_rows;
    }
    public function deleteOrganizationById($id){
        $sql = "UPDATE __empresa SET estado = 'INACTIVO', fecha_eliminacion = NOW() WHERE id = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->bind_param('i', $id);
        if (!$stmt->execute()) {
           throw new Exception('E504');
        }
        $affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $affected_rows;
    }
    public function createTypeOrganization($tipo_organizacion){
        $sql = "INSERT INTO __tipo_organizacion (tipo) VALUE (?);";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->bind_param("s", $tipo_organizacion);
        if (!$stmt->execute()) {
            throw new Exception('E502');
        }
        $id = $this->mysqli->insert_id;
        $stmt->close();
        return $id;
    }
    public function getOrganizationType($tipo){
        $sql = "SELECT id FROM __tipo_organizacion where tipo = ?";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->bind_param("s", $tipo);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $OrganizationType[] = $row;
        }
        $stmt->close();
        return $OrganizationType ?? [];
    }
    public function updateOrganizationType($id,$tipo){
        $sql = "UPDATE __tipo_organizacion SET tipo = ? WHERE id = ?";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->bind_param('si', $tipo,$id);
        if (!$stmt->execute()) {
            throw new Exception('E502');
        }
        $affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $affected_rows;
    }
    public function getUseOrganiationType($id){
        $sql = "SELECT * FROM __tipo_organizacion t INNER JOIN __empresa e ON e.id_tipo_organizacion = t.id WHERE t.id = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $OrganizationType[] = $row;
        }
        $stmt->close();
        return $OrganizationType ?? [];
    }
    public function deleteOrganizationTypeById($id){
        $sql = "DELETE FROM __tipo_organizacion WHERE id = ?;";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception('E501');
        }
        $stmt->bind_param("i", $id);
        if (!$stmt->execute()) {
            throw new Exception('E502');
        }
        $affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $affected_rows;
    }
    private function executeSelectQuery($sql,$type = '',$values = []){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        if($type != '') $stmt->bind_param($type, ...$values);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $resp[] = $row;
        }
        $stmt->close();
        return $resp ?? false;
    }
    private function executeProcedureUpdate($sql,$types,$values){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        $stmt->bind_param($types, ...$values);
        $stmt->execute();
        $stmt->close();
        while ($this->mysqli->more_results() && $this->mysqli->next_result()) {
            if ($res = $this->mysqli->use_result()) { $res->free(); }
        }
        $res = $this->mysqli->query("SELECT @p_rows_affected AS filas_afectadas");
        $filas_afectadas = $res->fetch_assoc()['filas_afectadas'] ?? null;
        $res->free();
        return $filas_afectadas;
    }
}