<?php
require_once 'controllers/EvaluacionController.php';
require_once 'utils/ValidateRequestField.php';

class Router {
    private $controller;
    private $method;
    private $uri;
    private $id;
    private $typeResource;

    public function __construct($mysqli,$header) {
        $this->method = $_SERVER['REQUEST_METHOD'];
        $this->uri = $_SERVER['REQUEST_URI'];
        $partes = array_filter(explode('/', rtrim($this->uri, '/')));
        $resource = isset($partes[3]) ? $partes[3] : '';
        $this->typeResource = $resource;
        $this->id = isset($partes[4]) && is_numeric($partes[4]) ? (int)$partes[4] : null;
        $this->controller = new EvaluacionController($mysqli,$header);
    }

    public function route($header) {
        switch ($this->method) {
            case 'GET':
                switch ($this->typeResource) {
                    case 'evaluaciones':
                        if($this->id){
                            ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        }
                        $this->controller->obtenerEvaluaciones();
                        break;
                    case 'evaluacion-detalle':
                        if(!$this->id){
                            ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        }
                        $this->controller->obtenerEvaluacionDetalle($this->id);
                        break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'POST':
                $input = file_get_contents('php://input');
                $data = json_decode($input, true);
                if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                switch ($this->typeResource) {
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'DELETE':
                if(!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                switch ($this->typeResource) {
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                $this->controller->delete($this->id);
                break;
            case 'PATCH':
                if(!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                $input = file_get_contents('php://input');
                $data = json_decode($input, true);
                if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                switch ($this->typeResource) {
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;            
            default:
                ApiResponse::error('E001');
                break;
        }
    }
}
?>