<?php
require_once __DIR__ . '/../models/Evaluacion.php';
class EvaluacionController {
    private $evaluacionModel;
    private $dataErrors = [];
    private $header = [];
    public function __construct($mysqli,$header) {
        $this->evaluacionModel = new Evaluacion($mysqli,$header);
        $this->header = $header;
    }

    /* EVALUACION DE DESEMPEÑO
     funciones de creacion */
    public function crearEvaluacion($data){
        try {
            $outp = $this->evaluacionModel->crearEvaluacion($data);
            if($outp) ApiResponse::success('S001',$outp);
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }    
    public function crearDimension($data){
        try {
            $outp = $this->evaluacionModel->crearDimension($data);
            if($outp) ApiResponse::success('S001',$outp);
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function crearSubdimension($data){
        try {
            $outp = $this->evaluacionModel->crearSubdimension($data);
            if($outp) ApiResponse::success('S001',$outp);
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function crearIndicadorDesempeno($data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    if(isset($data['id_subdimension'])) $evalSD = $this->evaluacionModel->obtenerSubdimensionByIdSuperadmin($data['id_subdimension']);
                    break;
                case 'ADMIN':
                    if(isset($data['id_subdimension'])) $evalSD = $this->evaluacionModel->obtenerSubdimensionByIdAdmin($data['id_subdimension']);
                    break;
                case 'USER_RH':
                    if(isset($data['id_subdimension'])) $evalSD = $this->evaluacionModel->obtenerSubdimensionByIdUserRH($data['id_subdimension']);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if(!$evalSD) throw new Exception("E404");
            if($evalSD[0]['id_dimension'] == $data['id_dimension'] && $evalSD['0']['id_evaluacion'] == $data['id_evaluacion']){
                $outp = $this->evaluacionModel->crearIndicadorDesempeno($data);
                if($outp) ApiResponse::success('S001',$outp);
            }else{
                throw new Exception("E404");
            }
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }    
    /* funciones de obtencion */
    public function obtenerEvaluacionById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->obtenerEvaluacionByIdSuperadmin($id);
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->obtenerEvaluacionByIdAdmin($id);
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->obtenerEvaluacionByIdUserRH($id);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function obtenerEvaluaciones(){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->obtenerEvaluacionSuperadmin();
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->obtenerEvaluacionAdmin();
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->obtenerEvaluacionUserRH();
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function obtenerDimensionById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->obtenerDimensionByIdSuperAdmin($id);
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->obtenerDimensionByIdAdmin($id);
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->obtenerDimensionByIdUserRH($id);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function obtenerDimensiones($data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->obtenerDimensionesSuperadmin($data);
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->obtenerDimensionesAdmin($data);
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->obtenerDimensionesUserRH($data);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function obtenerSubdimension($data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->obtenerSubdimensionSuperadmin($data);
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->obtenerSubdimensionAdmin($data);
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->obtenerSubdimensionUserRH($data);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function obtenerSubdimensionById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->obtenerSubdimensionByIdSuperadmin($id);
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->obtenerSubdimensionByIdAdmin($id);
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->obtenerSubdimensionByIdUserRH($id);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function obtenerIndicadorDesempeno($data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->obtenerIndicadorDesenpenoSuperadmin($data);
                    if(!$outp) throw new Exception("E404");
                    $resp = $this->formateaIndicadorDesempeno($outp);
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->obtenerIndicadorDesenpenoAdmin($data);
                    if(!$outp) throw new Exception("E404");
                    $resp = $this->formateaIndicadorDesempeno($outp);
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->obtenerIndicadorDesenpenoUserRH($data);
                    if(!$outp) throw new Exception("E404");
                    $resp = $this->formateaIndicadorDesempeno($outp);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function obtenerIndicadorDesempenoById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->obtenerIndicadorDesenpenoByIdSuperadmin($id);
                    if(!$outp) throw new Exception("E404");
                    $resp = $this->formateaIndicadorDesempeno($outp);
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->obtenerIndicadorDesenpenoByIdAdmin($id);
                    if(!$outp) throw new Exception("E404");
                    $resp = $this->formateaIndicadorDesempeno($outp);
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->obtenerIndicadorDesenpenoByIdUserRH($id);
                    if(!$outp) throw new Exception("E404");
                    $resp = $this->formateaIndicadorDesempeno($outp);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function obtenerIndicadorDesempenoSubdimension($data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    if(isset($data['id_subdimension'])) $evalSD = $this->evaluacionModel->obtenerSubdimensionById($data['id_subdimension']);
                    if(!$evalSD) throw new Exception("E404");
                    if($evalSD[0]['id_dimension'] == $data['id_dimension'] && $evalSD['0']['id_evaluacion'] == $data['id_evaluacion']){
                        $outp = $this->evaluacionModel->obtenerIndicadorDesempenoSubdimensionSuperadmin($data);
                    }else{
                        throw new Exception("E404");
                    }
                    break;
                case 'ADMIN':
                    if(isset($data['id_subdimension'])) $evalSD = $this->evaluacionModel->obtenerSubdimensionById($data['id_subdimension']);
                    if(!$evalSD) throw new Exception("E404");
                    if($evalSD[0]['id_dimension'] == $data['id_dimension'] && $evalSD['0']['id_evaluacion'] == $data['id_evaluacion']){
                        $outp = $this->evaluacionModel->obtenerIndicadorDesempenoSubdimensionAdmin($data);
                    }else{
                        throw new Exception("E404");
                    }
                    break;
                case 'USER_RH':
                    if(isset($data['id_subdimension'])) $evalSD = $this->evaluacionModel->obtenerSubdimensionById($data['id_subdimension']);
                    if(!$evalSD) throw new Exception("E404");
                    if($evalSD[0]['id_dimension'] == $data['id_dimension'] && $evalSD['0']['id_evaluacion'] == $data['id_evaluacion']){
                        $outp = $this->evaluacionModel->obtenerIndicadorDesempenoSubdimensionUserRH($data);
                    }else{
                        throw new Exception("E404");
                    }
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if(!$outp) ApiResponse::success('S001',[]);
            $resp = $this->formateaIndicadorDesempeno($outp);
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    /* funciones de eliminacion */
    public function eliminarEvaluacionById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $evaluacion = $this->evaluacionModel->obtenerEvaluacionByIdSuperadmin($id);
                    $delete = $this->evaluacionModel->deleteEvaluacionByIdSuperadmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "EVALUACION"
                        ,"id_usuario" => $evaluacion[0]['id_usuario_asignado']
                        ,"id_empresa" => $evaluacion[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'ADMIN':
                    $evaluacion = $this->evaluacionModel->obtenerEvaluacionByIdAdmin($id);
                    $delete = $this->evaluacionModel->deleteEvaluacionByIdAdmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "EVALUACION"
                        ,"id_usuario" => $evaluacion[0]['id_usuario_asignado']
                        ,"id_empresa" => $evaluacion[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'USER_RH':
                    $delete = $this->evaluacionModel->deleteEvaluacionByIdUserRH($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "EVALUACION"
                        ,"id_usuario" => $this->header['User-Id']
                        ,"id_empresa" => $this->header['Business-Id']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            $addPapelera = $this->evaluacionModel->agregarPapeleraReciclaje($dataPapelera);
            $estadoPapelera = "OK";
            if(!$addPapelera) $estadoPapelera = "NOK";
            $outp = array("eliminacion"=>"OK","papelera"=> $estadoPapelera);
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function eliminarDimensionById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $evaluacion = $this->evaluacionModel->obtenerEvaluacion_dimensionbyId($id);
                    $delete = $this->evaluacionModel->deleteDimensionByIdSuperadmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "DIMENSION"
                        ,"id_usuario" => $evaluacion[0]['id_usuario_asignado']
                        ,"id_empresa" => $evaluacion[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'ADMIN':
                    $evaluacion = $this->evaluacionModel->obtenerEvaluacion_dimensionbyId($id);
                    $delete = $this->evaluacionModel->deleteDimensionByIdAdmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "DIMENSION"
                        ,"id_usuario" => $evaluacion[0]['id_usuario_asignado']
                        ,"id_empresa" => $evaluacion[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'USER_RH':
                    $delete = $this->evaluacionModel->deleteDimensionByIdUserRH($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "DIMENSION"
                        ,"id_usuario" => $this->header['User-Id']
                        ,"id_empresa" => $this->header['Business-Id']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            $addPapelera = $this->evaluacionModel->agregarPapeleraReciclaje($dataPapelera);
            $estadoPapelera = "OK";
            if(!$addPapelera) $estadoPapelera = "NOK";
            $outp = array("eliminacion"=>"OK","papelera"=> $estadoPapelera);
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function eliminarSubimensionById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $evaluacion = $this->evaluacionModel->obtenerEvaluacion_subdimensionbyId($id);
                    $delete = $this->evaluacionModel->deleteSubdimensionByIdSuperadmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "SUBDIMENSION"
                        ,"id_usuario" => $evaluacion[0]['id_usuario_asignado']
                        ,"id_empresa" => $evaluacion[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'ADMIN':
                    $evaluacion = $this->evaluacionModel->obtenerEvaluacion_subdimensionbyId($id);
                    $delete = $this->evaluacionModel->deleteSubdimensionByIdAdmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "SUBDIMENSION"
                        ,"id_usuario" => $evaluacion[0]['id_usuario_asignado']
                        ,"id_empresa" => $evaluacion[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'USER_RH':
                    $delete = $this->evaluacionModel->deleteSubdimensionByIdUserRH($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "SUBDIMENSION"
                        ,"id_usuario" => $this->header['User-Id']
                        ,"id_empresa" => $this->header['Business-Id']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            $addPapelera = $this->evaluacionModel->agregarPapeleraReciclaje($dataPapelera);
            $estadoPapelera = "OK";
            if(!$addPapelera) $estadoPapelera = "NOK";
            $outp = array("eliminacion"=>"OK","papelera"=> $estadoPapelera);
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function eliminarIndicadorDesempenoById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $evaluacion = $this->evaluacionModel->obtenerEvaluacion_indicadorDesempenobyId($id);
                    $delete = $this->evaluacionModel->deleteIndicadorDesempenoByIdSuperadmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "INDICADOR-DESEMPEÑO"
                        ,"id_usuario" => $evaluacion[0]['id_usuario_asignado']
                        ,"id_empresa" => $evaluacion[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'ADMIN':
                    $evaluacion = $this->evaluacionModel->obtenerEvaluacion_indicadorDesempenobyId($id);
                    $delete = $this->evaluacionModel->deleteIndicadorDesempenoByIdAdmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "INDICADOR-DESEMPEÑO"
                        ,"id_usuario" => $evaluacion[0]['id_usuario_asignado']
                        ,"id_empresa" => $evaluacion[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'USER_RH':
                    $delete = $this->evaluacionModel->deleteIndicadorDesenpenoByIdUserRH($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "INDICADOR-DESEMPEÑO"
                        ,"id_usuario" => $this->header['User-Id']
                        ,"id_empresa" => $this->header['Business-Id']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            $addPapelera = $this->evaluacionModel->agregarPapeleraReciclaje($dataPapelera);
            $estadoPapelera = "OK";
            if(!$addPapelera) $estadoPapelera = "NOK";
            $outp = array("eliminacion"=>"OK","papelera"=> $estadoPapelera);
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    /* funciones de actualización */
    public function modificarEvaluacionById($id,$data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $update = $this->evaluacionModel->updateEvaluacionByIdSuperadmin($id,$data);                    
                    break;
                case 'ADMIN':
                    $update = $this->evaluacionModel->updateEvaluacionByIdAdmin($id,$data);
                    break;
                case 'USER_RH':
                    $update = $this->evaluacionModel->updateEvaluacionByIdUserRH($id,$data);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($update['c'] == 0) throw new Exception("E404");
            if($update['c'] == 1 and $update['m'] == 0) ApiResponse::success('S001','No se han realizado cambios al registro');
            ApiResponse::success('S001','Registro actualizado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function modificarDimensionById($id,$data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $update = $this->evaluacionModel->updateDimensionByIdSuperadmin($id,$data);                    
                    break;
                case 'ADMIN':
                    $update = $this->evaluacionModel->updateDimensionByIdAdmin($id,$data);
                    break;
                case 'USER_RH':
                    $update = $this->evaluacionModel->updateDimensionByIdUserRH($id,$data);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($update['c'] == 0) throw new Exception("E404");
            if($update['c'] == 1 and $update['m'] == 0) ApiResponse::success('S001','No se han realizado cambios al registro');
            ApiResponse::success('S001','Registro actualizado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function modificarSubimensionById($id,$data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $update = $this->evaluacionModel->updateSubdimensionByIdSuperadmin($id,$data);                    
                    break;
                case 'ADMIN':
                    $update = $this->evaluacionModel->updateSubdimensionByIdAdmin($id,$data);
                    break;
                case 'USER_RH':
                    $update = $this->evaluacionModel->updateSubdimensionByIdUserRH($id,$data);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($update['c'] == 0) throw new Exception("E404");
            if($update['c'] == 1 and $update['m'] == 0) ApiResponse::success('S001','No se han realizado cambios al registro');
            ApiResponse::success('S001','Registro actualizado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function modificarIndicadorDesempenoById($id,$data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $update = $this->evaluacionModel->updateIndicadordesempenoByIdSuperadmin($id,$data);                    
                    break;
                case 'ADMIN':
                    $update = $this->evaluacionModel->updateIndicadordesempenoByIdAdmin($id,$data);
                    break;
                case 'USER_RH':
                    $update = $this->evaluacionModel->updateIndicadordesempenoByIdUserRH($id,$data);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($update['c'] == 0) throw new Exception("E404");
            if($update['c'] == 1 and $update['m'] == 0) ApiResponse::success('S001','No se han realizado cambios al registro');
            ApiResponse::success('S001','Registro actualizado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    /* NIVEL DE LOGRO 
    funciones de creacion */
    public function crearNivelLogro($data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->crearNivelLogroSuperadmin($data);
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->crearNivelLogroAdmin($data);
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->crearNivelLogroUserRH($data);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($outp) ApiResponse::success('S001',$outp);
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function crearDetalleNivelLogro($data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->crearDetalleNivelLogro($data);
                    break;
                case 'ADMIN':
                    $nivelLogro = $this->evaluacionModel->obtenerNivelLogro($data['id_nivel_logro']);
                    if($nivelLogro[0]['id_empresa'] != $this->header['Business-Id']) throw new Exception("E404");
                    $outp = $this->evaluacionModel->crearDetalleNivelLogro($data);
                    break;
                case 'USER_RH':
                    $nivelLogro = $this->evaluacionModel->obtenerNivelLogro($data['id_nivel_logro']);
                    if($nivelLogro[0]['id_empresa'] != $this->header['Business-Id'] || $nivelLogro[0]['id_usuario_asignado']!=$this->header['User-Id']) throw new Exception("E404");
                    $outp = $this->evaluacionModel->crearDetalleNivelLogro($data);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($outp) ApiResponse::success('S001',$outp);
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    /* funciones de obtencion */
    public function obtenerNivelLogro(){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->obtenerNivelLogroSuperadmin();
                    if(!$outp) throw new Exception("E404");
                    $resp = $this->formateaNivelLogro($outp);
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->obtenerNivelLogroAdmin();
                    if(!$outp) throw new Exception("E404");
                    $resp = $this->formateaNivelLogro($outp);
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->obtenerNivelLogroUserRH();
                    if(!$outp) throw new Exception("E404");
                    $resp = $this->formateaNivelLogro($outp);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
           if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function obtenerNivelLogroById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $outp = $this->evaluacionModel->obtenerNivelLogroByIdSuperadmin($id);
                    if(!$outp) throw new Exception("E404");
                    break;
                case 'ADMIN':
                    $outp = $this->evaluacionModel->obtenerNivelLogroByIdAdmin($id);
                    if(!$outp) throw new Exception("E404");
                    break;
                case 'USER_RH':
                    $outp = $this->evaluacionModel->obtenerNivelLogroByIdUserRH($id);
                    if(!$outp) throw new Exception("E404");
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            $resp = $this->formateaNivelLogro($outp);
            if($resp) ApiResponse::success('S001',$resp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    /* funciones de eliminacion */
    public function eliminarNivelLogroById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $datosNivel = $this->evaluacionModel->obtenerNivelLogro($id);                
                    $delete = $this->evaluacionModel->eliminarNivelLogroSuperadmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "NIVEL-LOGRO"
                        ,"id_usuario" => $datosNivel[0]['id_usuario_asignado']
                        ,"id_empresa" => $datosNivel[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'ADMIN':
                    $datosNivel = $this->evaluacionModel->obtenerNivelLogro($id);
                    $delete = $this->evaluacionModel->eliminarNivelLogroAdmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "NIVEL-LOGRO"
                        ,"id_usuario" => $datosNivel[0]['id_usuario_asignado']
                        ,"id_empresa" => $datosNivel[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'USER_RH':
                    $delete = $this->evaluacionModel->eliminarNivelLogroUserRH($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "NIVEL-LOGRO"
                        ,"id_usuario" => $this->header['User-Id']
                        ,"id_empresa" => $this->header['Business-Id']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            $addPapelera = $this->evaluacionModel->agregarPapeleraReciclaje($dataPapelera);
            $estadoPapelera = "OK";
            if(!$addPapelera) $estadoPapelera = "NOK";
            $outp = array("eliminacion"=>"OK","papelera"=> $estadoPapelera);
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function eliminarDetalleNivelLogroById($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $datosNivel = $this->evaluacionModel->obtenerNivelLogroByDetalleId($id);                
                    $delete = $this->evaluacionModel->eliminarNivelLogroDetalleSuperadmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "DETALLE-NIVEL-LOGRO"
                        ,"id_usuario" => $datosNivel[0]['id_usuario_asignado']
                        ,"id_empresa" => $datosNivel[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'ADMIN':
                    $datosNivel = $this->evaluacionModel->obtenerNivelLogroByDetalleId($id);
                    $delete = $this->evaluacionModel->eliminarNivelLogroDetalleAdmin($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "DETALLE-NIVEL-LOGRO"
                        ,"id_usuario" => $datosNivel[0]['id_usuario_asignado']
                        ,"id_empresa" => $datosNivel[0]['id_empresa']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                case 'USER_RH':
                    $delete = $this->evaluacionModel->eliminarNivelLogroDetalleUserRH($id);
                    if($delete['m'] == 0) ApiResponse::error('E404');
                    $dataPapelera = array("idElemento"=> $id
                        ,"tipo_elemento" =>  "DETALLE-NIVEL-LOGRO"
                        ,"id_usuario" => $this->header['User-Id']
                        ,"id_empresa" => $this->header['Business-Id']
                        ,"uuid_eliminacion" => $this->generateUuidV4()
                        ,"id_usuario_eliminador" => $this->header['User-Id']
                    );
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            $addPapelera = $this->evaluacionModel->agregarPapeleraReciclaje($dataPapelera);
            $estadoPapelera = "OK";
            if(!$addPapelera) $estadoPapelera = "NOK";
            $outp = array("eliminacion"=>"OK","papelera"=> $estadoPapelera);
            if($outp) ApiResponse::success('S001',$outp); throw new Exception("E404");
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    /* funciones de actualizacion */
    public function modificarNivelLogroById($id,$data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $update = $this->evaluacionModel->updateNivelLogroByIdSuperadmin($id,$data);                    
                    break;
                case 'ADMIN':
                    $update = $this->evaluacionModel->updateNivelLogroByIdAdmin($id,$data);
                    break;
                case 'USER_RH':
                    $update = $this->evaluacionModel->updateNivelLogroByIdUserRH($id,$data);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($update['c'] == 0) throw new Exception("E404");
            if($update['c'] == 1 and $update['m'] == 0) ApiResponse::success('S001','No se han realizado cambios al registro');
            ApiResponse::success('S001','Registro actualizado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
    public function modificarDetalleNivelLogroById($id,$data){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $update = $this->evaluacionModel->updateDetalleNivelLogroByIdSuperadmin($id,$data);                    
                    break;
                case 'ADMIN':
                    $update = $this->evaluacionModel->updateDetalleNivelLogroByIdAdmin($id,$data);
                    break;
                case 'USER_RH':
                    $update = $this->evaluacionModel->updateDetalleNivelLogroByIdUserRH($id,$data);
                    break;
                default:
                    throw new Exception("E401");
                    break;
            }
            if($update['c'] == 0) throw new Exception("E404");
            if($update['c'] == 1 and $update['m'] == 0) ApiResponse::success('S001','No se han realizado cambios al registro');
            ApiResponse::success('S001','Registro actualizado');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }

    /* funciones privadas de la clase*/
    /* formatear el resultado de la consulta de indicador de desempeño*/
    private function formateaIndicadorDesempeno($data){
        $grouped = [];

        foreach ($data as $row) {
            // clave de agrupación estable
            $key = implode('|', [
                (string)($row['id_dimension'] ?? ''),
                (string)($row['id_subdimension'] ?? ''),
                (string)($row['nombre_subdimension'] ?? ''),
                (string)($row['id_evaluacion'] ?? '')
            ]);

            if (!isset($grouped[$key])) {
                $grouped[$key] = [
                    'id_subdimension'    => $row['id_subdimension'] ?? null,
                    'id_dimension'       => $row['id_dimension'] ?? null,
                    'nombre_subdimension'=> $row['nombre_subdimension'] ?? null,
                    'id_evaluacion'      => $row['id_evaluacion'] ?? null,
                    'indicador_desempeno'=> [] // <— con ñ, preservado en UTF-8
                ];
            }

            // arma cada indicador con los campos que quieres mostrar
            $indicator = [];
            if (array_key_exists('id_indicador_desempeno', $row)) {
                $indicator['id_indicador_desempeno'] = $row['id_indicador_desempeno'];
            }
            if (array_key_exists('nombre_indicador_desempeno', $row)) {
                $indicator['nombre_indicador_desempeno'] = $row['nombre_indicador_desempeno'];
            }

            $grouped[$key]['indicador_desempeno'][] = $indicator;
        }

        $output = array_values($grouped);
        return $output;
    }
    private function formateaNivelLogro($data){
        $grouped = [];

        foreach ($data as $row) {
            // clave de agrupación estable
            $key = implode('|', [
                (string)($row['id_nivel_logro'] ?? ''),
                (string)($row['nombre_nivel'] ?? ''),
                (string)($row['descripcion_nivel'] ?? ''),
                (string)($row['estado'] ?? '')
            ]);

            if (!isset($grouped[$key])) {
                $grouped[$key] = [
                    'id_nivel_logro'    => $row['id_nivel_logro'] ?? null,
                    'nombre_nivel'       => $row['nombre_nivel'] ?? null,
                    'descripcion_nivel'=> $row['descripcion_nivel'] ?? null,
                    'estado'      => $row['estado'] ?? null,
                    'detalle_nivel'=> [] // <— con ñ, preservado en UTF-8
                ];
            }
            // arma cada indicador con los campos que quieres mostrar
            $indicator = [];
            if (array_key_exists('id_detalle_nivel', $row)) $indicator['id_detalle_nivel'] = $row['id_detalle_nivel'];
            if (array_key_exists('nombre_detalle_nivel', $row)) $indicator['nombre_detalle_nivel'] = $row['nombre_detalle_nivel'];
            if (array_key_exists('valor', $row)) $indicator['valor'] = $row['valor'];
            if ($indicator != []) $grouped[$key]['detalle_nivel'][] = $indicator;
        }

        $output = array_values($grouped);
        return $output;
    }
    /* funcion de generacion de UUID v4 */
    private function generateUuidV4(): string {
        $data = random_bytes(16);
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40); // Establecer versión 4
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80); // Establecer variante
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    }
}
?>