<?php
require_once 'controllers/EvaluacionController.php';
require_once 'utils/ValidateRequestField.php';

class Router {
    private $controller;
    private $method;
    private $uri;
    private $id;
    private $typeResource;

    public function __construct($mysqli,$header) {
        $this->method = $_SERVER['REQUEST_METHOD'];
        $this->uri = $_SERVER['REQUEST_URI'];
        $partes = array_filter(explode('/', rtrim($this->uri, '/')));
        $resource = isset($partes[3]) ? $partes[3] : '';
        $this->typeResource = $resource;
        $this->id = isset($partes[4]) && is_numeric($partes[4]) ? (int)$partes[4] : null;
        $this->controller = new EvaluacionController($mysqli,$header);
    }

    public function route($header) {
        switch ($this->method) {
            case 'GET':
                switch ($this->typeResource) {
                    case 'evaluacion':
                        if($this->id){
                            $this->controller->obtenerEvaluacionById($this->id);
                        }
                        $this->controller->obtenerEvaluaciones();
                        break;
                    case 'dimension':
                        if($this->id){
                            $this->controller->obtenerDimensionById($this->id);
                        }
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateRequest::obtenerDimensiones($data)) ApiResponse::error('E400',$error);
                        $this->controller->obtenerDimensiones($data);
                        break;
                    case 'subdimension':
                        if($this->id){
                            $this->controller->obtenerSubdimensionById($this->id);
                        }
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateRequest::obtenerSubdimension($data)) ApiResponse::error('E400',$error);
                        $this->controller->obtenerSubdimension($data);
                        break;
                    case 'indicador-desempeno':
                        if($this->id){
                            $this->controller->obtenerIndicadorDesempenoById($this->id);
                        }
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateRequest::obtenerIndicadorDesempeno($data)) ApiResponse::error('E400',$error);
                        $this->controller->obtenerIndicadorDesempeno($data);
                        break;
                    case 'indicador-desempeno-subdimension':
                        if($this->id){
                            ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        }
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateRequest::obtenerIndicadorDesempenoSubdimension($data)) ApiResponse::error('E400',$error);
                        $this->controller->obtenerIndicadorDesempenoSubdimension($data);
                        break;
                        break;
                    case 'nivel-logro':
                        if($this->id){
                            $this->controller->obtenerNivelLogroById($this->id);
                        }
                        $this->controller->obtenerNivelLogro();
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'POST':
                $input = file_get_contents('php://input');
                $data = json_decode($input, true);
                if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                switch ($this->typeResource) {
                    case 'evaluacion':
                        if($error = ValidateRequest::crearEvaluacion($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearEvaluacion($data);
                        break;
                    case 'dimension':
                        if($error = ValidateRequest::crearDimension($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearDimension($data);
                        break;
                    case 'subdimension':
                        if($error = ValidateRequest::crearSubdimension($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearSubdimension($data);
                        break;
                    case 'indicador-desempeno':
                        if($error = ValidateRequest::crearIndicadorDesempeno($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearIndicadorDesempeno($data);
                        break;
                    case 'nivel-logro':
                        if($error = ValidateRequest::crearNivelLogro($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearNivelLogro($data);
                    case 'detalle-nivel-logro':
                        if($error = ValidateRequest::crearDetalleNivelLogro($data)) ApiResponse::error('E400',$error);
                        $this->controller->crearDetalleNivelLogro($data);
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'DELETE':
                if(!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                switch ($this->typeResource) {
                    case 'evaluacion':
                        $this->controller->eliminarEvaluacionById($this->id);
                        break;
                    case 'dimension':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateRequest::eliminarDimension($data)) ApiResponse::error('E400',$error);
                        $this->controller->eliminarDimensionById($this->id);
                        break;
                    case 'subdimension':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateRequest::eliminarSubdimension($data)) ApiResponse::error('E400',$error);
                        $this->controller->eliminarSubimensionById($this->id);
                        break;
                    case 'indicador-desempeno':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateRequest::eliminarIndicadorDesempeno($data)) ApiResponse::error('E400',$error);
                        $this->controller->eliminarIndicadorDesempenoById($this->id);
                        break;
                    case 'nivel-logro':
                        $this->controller->eliminarNivelLogroById($this->id);
                        break;
                    case 'detalle-nivel-logro':
                        $this->controller->eliminarDetalleNivelLogroById($this->id);
                        break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                        break;
                }
                if (!$this->id) {
                    http_response_code(400);
                    echo json_encode(['error' => 'ID requerido']);
                    exit;
                }
                $this->controller->delete($this->id);
                break;
            case 'PATCH':
                if(!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                $input = file_get_contents('php://input');
                $data = json_decode($input, true);
                if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                switch ($this->typeResource) {
                    case 'evaluacion':
                        if($error = ValidateRequest::modificarEvaluacion($data)) ApiResponse::error('E400',$error);
                        $this->controller->modificarEvaluacionById($this->id,$data);
                        break;
                    case 'dimension':
                        if($error = ValidateRequest::modificarDimension($data)) ApiResponse::error('E400',$error);
                        $this->controller->modificarDimensionById($this->id,$data);
                        break;
                    case 'subdimension':
                        if($error = ValidateRequest::modificarSubdimension($data)) ApiResponse::error('E400',$error);
                        $this->controller->modificarSubimensionById($this->id,$data);
                        break;
                    case 'indicador-desempeno':
                        if($error = ValidateRequest::modificarIndicadorDesempeno($data)) ApiResponse::error('E400',$error);
                        $this->controller->modificarIndicadorDesempenoById($this->id,$data);
                        break;
                    case 'nivel-logro':
                        if($error = ValidateRequest::modificarNivelLogro($data)) ApiResponse::error('E400',$error);
                        $this->controller->modificarNivelLogroById($this->id,$data);
                        break;
                    case 'detalle-nivel-logro':
                        if($error = ValidateRequest::modificarDetalleNivelLogro($data)) ApiResponse::error('E400',$error);
                        $this->controller->modificarDetalleNivelLogroById($this->id,$data);
                        break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;            
            default:
                ApiResponse::error('E001');
                break;
        }
    }
}
?>