<?php
require_once 'controllers/LoginController.php';
require_once 'utils/ValidateFieldRule.php';
class Router {
    private $controller;
    private $method;
    private $uri;
    private $id;
    private $typeResource;

    public function __construct($mysqli,$config) {
        $this->method = $_SERVER['REQUEST_METHOD'];
        $this->uri = $_SERVER['REQUEST_URI'];
        $partes = array_filter(explode('/', rtrim($this->uri, '/')));
        $resource = isset($partes[3]) ? $partes[3] : '';
        $this->typeResource = $resource;
        $this->id = isset($partes[4]) && is_numeric($partes[4]) ? (int)$partes[4] : null;
        if ($resource === 'login' || $resource === 'reset-password' || $resource==='verify-otp' || $resource === 'change-password') {
            $this->controller = new LoginController($mysqli,$config);
        } else {
            ApiResponse::error('E011','Recurso '.$resource.' no encontrado');
        }
    }

    public function route() {
        switch ($this->method) {
            case 'POST':
                switch($this->typeResource){
                    case 'login':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        // manejo de error para la creacion de evaluaciones cuando el body no es provisto
                        if (!$data) { 
                            ApiResponse::error('E009');
                        }
                        $error = ValidateData::validateLoginRule($data);
                        if($error) ApiResponse::error('E008',$error);
                        $this->controller->login($data);
                        break;
                    case 'reset-password':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        // manejo de error para la creacion de evaluaciones cuando el body no es provisto
                        if (!$data) { 
                            ApiResponse::error('E009');
                        }
                        $error = ValidateData::validateResetPasswordRule($data);
                        if($error) ApiResponse::error('E008',$error);
                        $this->controller->send_email($data);
                        break;
                    case 'verify-otp':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        // manejo de error para la creacion de evaluaciones cuando el body no es provisto
                        if (!$data) { 
                            ApiResponse::error('E009');
                        }
                        $error = ValidateData::validateVerifyOTPRule($data);
                        if($error) ApiResponse::error('E008',$error);
                        $this->controller->verify_otp($data);
                        break;
                    case 'change-password':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        // manejo de error para la creacion de evaluaciones cuando el body no es provisto
                        if (!$data) { 
                            ApiResponse::error('E009');
                        }
                        $error = ValidateData::validateChangePaswordRule($data);
                        if($error) ApiResponse::error('E008',$error);
                        $this->controller->change_password($data);
                        break;
                    default:
                        ApiResponse::error('E011','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;

            default:
                ApiResponse::error('E010');
                break;
        }
    }
}
?>