<?php
class ErrorDictionary {
    public static function getErrorStructure($errorCode,$errorMessage = NULL,$data = NULL){
        $errors = [
            'E001' => [
                "statusCode" => 401,
                "code" => 'E001',
                "message" => 'Usuario no encontrado',
                "type" => 'error',
                "errors" => 'usuario no encontrado o invalido',
                "data" => $data
            ],
            'E002' => [
                "statusCode" => 401,
                "code" => 'E002',
                "message" => 'Usuario Bloquado, por favor comuniquese con su administrador o recupere su contraseña',
                "type" => 'error',
                "errors" => 'Usuario bloqueado en el sistema',
                "data" => $data
            ],
            'E003' => [
                "statusCode" => 401,
                "code" => 'E003',
                "message" => 'Contraseña invalida, intentos restantes: 2',
                "type" => 'error',
                "errors" => 'Contraseña invalida',
                "data" => $data
            ],
            'E004' => [
                "statusCode" => 401,
                "code" => 'E004',
                "message" => 'Contraseña invalida, intentos restantes: 1',
                "type" => 'error',
                "errors" => 'Contraseña invalida',
                "data" => $data
            ],
            'E005' => [
                "statusCode" => 401,
                "code" => 'E005',
                "message" => 'Usuario Bloqueado, por favor comuniquese con su administrador o recupere su contraseña',
                "type" => 'error',
                "errors" => 'Contraseña invalida',
                "data" => $data
            ],
            'E006' => [
                "statusCode" => 500,
                "code" => 'E006',
                "message" => 'Error interno del sistema, por favor intente mas tarde',
                "type" => 'error',
                "errors" => 'Internal server error: Error en proceso de preparación de consulta',
                "data" => $data
            ],
            'E007' => [
                "statusCode" => 500,
                "code" => 'E007',
                "message" => 'Error interno del sistema, por favor intente mas tarde',
                "type" => 'error',
                "errors" => 'Internal server error: Error en etapa de ejecución de consulta',
                "data" => $data
            ],
            'E008' => [
                "statusCode" => 400,
                "code" => 'E008',
                "message" => 'Parametros invalidos',
                "type" => 'error',
                "errors" => $errorMessage,
                "data" => $data
            ],
            'E009' => [
                "statusCode" => 400,
                "code" => 'E009',
                "message" => 'Parametros invalidos',
                "type" => 'error',
                "errors" => 'JSON no provisto o invalido',
                "data" => $data
            ],
            'E010' => [
                "statusCode" => 405,
                "code" => 'E010',
                "message" => 'Método no permitido',
                "type" => 'error',
                "errors" => 'Método no permitido',
                "data" => $data
            ],
            'E011' => [
                "statusCode" => 404,
                "code" => 'E011',
                "message" => 'Recurso No encontrado',
                "type" => 'error',
                "errors" => $errorMessage,
                "data" => $data
            ],
            'E012' => [
                "statusCode" => 400,
                "code" => 'E001',
                "message" => 'Email ingresado invalido',
                "type" => 'error',
                "errors" => 'Relación Usuario Email invalida',
                "data" => $data
            ],
            'E013' => [
                "statusCode" => 401,
                "code" => 'E013',
                "message" => 'OTP bloqueada, no es posible continuar la solicitud',
                "type" => 'error',
                "errors" => 'OTP bloqueado en el sistema',
                "data" => $data
            ],
            'E014' => [
                "statusCode" => 401,
                "code" => 'E014',
                "message" => 'OTP invalida, intentos restantes: 2',
                "type" => 'error',
                "errors" => 'OTP invalida',
                "data" => $data
            ],
            'E015' => [
                "statusCode" => 401,
                "code" => 'E015',
                "message" => 'OTP invalida, intentos restantes: 1',
                "type" => 'error',
                "errors" => 'OTP invalida',
                "data" => $data
            ],'E016' => [
                "statusCode" => 401,
                "code" => 'E016',
                "message" => 'Parametros ingresados invalidos',
                "type" => 'error',
                "errors" => 'Los parametros ingresados no corresponden al proceso en curso',
                "data" => $data
            ]
        ];
        return $errors[$errorCode] ?? [
            "statusCode" => 500,
            "code" => 'E-999',
            "message" => 'Error desconocido en el sistema, por favor intente mas tarde',
            "type" => 'error',
            "errors" => 'Internal server error: '.$errorCode,
            "data" => $data
        ];
    }
    public static function getSuccessStructure($code,$data = NULL,$error = NULL){
        $success = [
            'S001' => [
                "statusCode" => 200,
                "code" => 'S001',
                "message" => '¡Inicio de sesión exitoso!',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
            'S002' => [
                "statusCode" => 200,
                "code" => 'S002',
                "message" => 'OTP enviada al correo del usuario',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
            'S003' => [
                "statusCode" => 200,
                "code" => 'S003',
                "message" => 'Validación de OTP exitosa',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ],
            'S004' => [
                "statusCode" => 200,
                "code" => 'S004',
                "message" => 'Contraseña modificada con exito',
                "type" => 'success',
                "errors" => $error,
                "data" => $data
            ]
        ];
        return $success[$code] ?? [
            "statusCode" => 200,
            "code" => 'S000',
            "message" => 'Solicitud procesada exitosamente',
            "type" => 'success',
            "errors" => $error,
            "data" => $data
        ];
    }
}

?>