<?php
function validateProcess($validationRules,$data){
        $errors = [];
    
    foreach ($validationRules as $field => $rule) {
        // Verificar si el campo es obligatorio
        if ($rule['required'] && !isset($data[$field])) {
            $errors[] = "Field '$field' is required";
            continue;
        }
        // Si el campo no está presente y no es obligatorio, continuar
        if (!isset($data[$field]) && !$rule['required']) {
            continue;
        }
        // Verificar si el campo puede estar vacio
        if ($rule['notEmpty'] && $data[$field]==""){
            $errors[] = "Field '$field' must not be empty";
            continue;
        }
        
        
        $value = $data[$field];
        
        // Validar tipo de dato
        switch ($rule['type']) {
            case 'string':
                if (!is_string($value)) $errors[] = "Field '$field' must be a string";
                if (isset($rule['max_length']) && strlen($value) > $rule['max_length']) $errors[] = "Field '$field' exceeds maximum length of {$rule['max_length']}";
                if (isset($rule['length']) && strlen($value) != $rule['length']) $errors[] = "Field '$field' has a length other than {$rule['length']}";
                break;
            case 'integer':
                if (!is_numeric($value) || floor($value) != $value) $errors[] = "Field '$field' must be an integer";
                if (isset($rule['min']) && $value < $rule['min']) $errors[] = "Field '$field' must be at least {$rule['min']}";
                if (isset($rule['max']) && $value > $rule['max']) $errors[] = "Field '$field' must not exceed {$rule['max']}";
                break;
            case 'email':
                if (!filter_var($value, FILTER_VALIDATE_EMAIL)) $errors[] = "Field '$field' must be a valid email address";
                break;
            case 'boolean':
                if (!is_bool($value) && $value !== 0 && $value !== 1) $errors[] = "Field '$field' must be a boolean";
                break;
            case 'datetime':
                $format = 'Y-m-d H:i:s';
                $dateTime = DateTime::createFromFormat($format, $value);
                if (!$dateTime || $dateTime->format($format) !== $value) $errors[] = "Field '$field' must be a valid datetime (YYYY-MM-DD HH:MM:SS)";
                break;
            case 'date':
                $format = 'Y-m-d';
                $dateTime = DateTime::createFromFormat($format, $value);
                if (!$dateTime || $dateTime->format($format) !== $value) $errors[] = "Field '$field' must be a valid datetime (YYYY-MM-DD)";
                break;
        }
    
    }
    return $errors;
}
class ValidateData{
    public static function validateLoginRule($data){
        $validationRules = [
            'usuario' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 50
            ],
            'contrasena' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'length' => 64
            ]
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validateResetPasswordRule($data){
        $validationRules = [
            'usuario' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 50
            ],
            'email' => [
                'type' => 'email',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 254
            ],
        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validateVerifyOTPRule($data){
        $validationRules = [
            'usuario' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 50
            ],
            'email' => [
                'type' => 'email',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 254
            ],
            'identificador'=>[
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 36
            ],
            'otp'=>[
                'type' => 'integer',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 6
            ],

        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
    public static function validateChangePaswordRule($data){
        $validationRules = [
            'usuario' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 50
            ],
            'contrasena' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'length' => 12
            ],
            'hash_auth' => [
                'type' => 'string',
                'notEmpty' => true,
                'required' => false,
                'length' => 64
            ],
            'email' => [
                'type' => 'email',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 254
            ],
            'identificador'=>[
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 36
            ],
            'sessionCode'=>[
                'type' => 'string',
                'notEmpty' => true,
                'required' => true,
                'max_length' => 36
            ],

        ];
        $errors = validateProcess($validationRules,$data);
        return $errors;
    }
}

?>