<?php
class Organizacion{
    private $mysqli;
    private $header;

    public function __construct($mysqli,$header){
        $this->mysqli = $mysqli;
        $this->mysqli->set_charset("utf8mb4");
        $this->header = $header;
    }
    
    public function crearPuestoEmpresa($data){
        $sql = "CALL sp_crear_puesto_empresa(?,?,?);";
        $types = "ssi";
        $values = array($data['puesto']
            ,$data['descripcion']
            ,$this->header['Business-Id']
        );
        $resp = $this->executeProcedureCreate($sql,$types,$values);
        return $resp;
    }
    public function crearDepartamentoEmpresa($data){
        $sql = "CALL sp_crear_departamento_empresa(?,?,?);";
        $types = "sii";
        $values = array($data['departamento']
            ,$this->header['Business-Id']
            ,!empty($data['id_departamento_superior']) ? (int)$data['id_departamento_superior'] : NULL
        );
        $resp = $this->executeProcedureCreate($sql,$types,$values);
        return $resp;
    }
    public function crearColaboradorEmpresa($data){
        $sql = "CALL sp_crear_colaborador_empresa(?,?,?,?,?,?,?,?,?,?);";
        $types = "isssssiiii";
        $values = array($data['rut']
            , $data['dv']
            , $data['nombre']
            , $data['apellido_1']
            , $data['apellido_2']
            , $data['email']
            , $this->header['Business-Id']
            , $data['id_departamento']
            , $this->nullOr($data['id_jefe'] ?? null, 'int')
            , $data['id_puesto']
        );
        $resp = $this->executeProcedureCreate($sql,$types,$values);
        return $resp;
    }
    public function actualizarColaboradorEmpresa($data, $id) {
        $sql = "CALL sp_actualizar_colaborador_empresa(?,?,?,?,?,?,?,?,?,?,?,?,?);";
        $types = "iisssssiiiiis";
        $values = array(
            $id
            , $this->nullOr($data['rut'] ?? null, 'int')
            , $this->nullOr($data['dv'] ?? null)
            , $this->nullOr($data['nombre'] ?? null)
            , $this->nullOr($data['apellido_1'] ?? null)
            , $this->nullOr($data['apellido_2'] ?? null)
            , $this->nullOr($data['email'] ?? null)
            , $this->header['Business-Id']
            , $this->nullOr($data['id_departamento'] ?? null, 'int')
            , $this->nullOr($data['id_jefe'] ?? null, 'int')
            , isset($data['id_jefe']) ? 1 : 0
            , $this->nullOr($data['id_puesto'] ?? null, 'int')
            , null
        );

        $resp = $this->executeProcedureUpdate($sql, $types, $values);
        return $resp;
    }
    public function bloqueaColaboradorEmpresa($id) {
        $sql = "CALL sp_actualizar_estado_colaborador_empresa(?,?,?);";
        $types = "iis";
        $values = array(
            $id
            , $this->header['Business-Id']
            , 'BLOQUEADO'
        );
        $resp = $this->executeProcedureUpdate($sql, $types, $values);
        return $resp;
    }
    public function desbloqueaColaboradorEmpresa($id) {
        $sql = "CALL sp_actualizar_estado_colaborador_empresa(?,?,?);";
        $types = "iis";
        $values = array(
            $id
            , $this->header['Business-Id']
            , 'ACTIVO'
        );
        $resp = $this->executeProcedureUpdate($sql, $types, $values);
        return $resp;
    }
    public function eliminaColaboradorEmpresa($id) {
        $sql = "CALL sp_actualizar_estado_colaborador_empresa(?,?,?);";
        $types = "iis";
        $values = array(
            $id
            , $this->header['Business-Id']
            , 'INACTIVO'
        );
        $resp = $this->executeProcedureUpdate($sql, $types, $values);
        return $resp;
    }
    public function listarColaboradorEmpresa($data) {
        $sql = "CALL sp_listar_colaboradores_empresa_con_total(?,?,?,?,?,?)";
        $types = "isiiii";

        $empresaId = $this->header['Business-Id'];

        $estado = isset($data['estado']) && $data['estado'] !== '' ? $data['estado'] : null;
        $idDepartamento = isset($data['id_departamento']) ? (int)$data['id_departamento'] : null;
        $idPuesto = isset($data['id_puesto']) ? (int)$data['id_puesto'] : null;

        $offset = isset($data['offset']) && is_numeric($data['offset']) ? (int)$data['offset'] : 0;
        $limit = isset($data['limit']) && is_numeric($data['limit']) ? (int)$data['limit'] : 10;

        $values = [
            $empresaId,
            $estado,
            $idDepartamento,
            $idPuesto,
            $offset,
            $limit
        ];

        list($colaboradores, $totalResult) = $this->executeProcedureWithMultipleResults($sql, $types, $values);
        $total = $totalResult[0]['total_registros'] ?? 0;

        return [
            'colaboradores' => $colaboradores,
            'total' => (int)$total
        ];
    }
    public function listarPuestosEmpresa(){
        $sql = "CALL sp_listar_puestos_empresa(?)";
        $types = "i";
        $values = [$this->header['Business-Id']];
        $result = $this->executeProcedureRead($sql, $types, $values);
        return [
            'puestos' => $result
        ];
    }
    public function listarDepartamentosEmpresa() {
        $sql = "CALL sp_listar_departamentos_empresa(?)";
        $types = "i";
        $values = [$this->header['Business-Id']];
        $result = $this->executeProcedureRead($sql, $types, $values);
        return [
            'departamentos' => $result
        ];
    }
    public function estructuraDepartamentosEmpresa() {
        $sql = "CALL sp_obtener_estructura_departamental_empresa(?);";
        $types = "i";
        $values = [$this->header['Business-Id']];
        $result = $this->executeProcedureRead($sql, $types, $values);
        return [
            'departamentos' => $result
        ];
    }
    public function actualizarPuestoTrabajoEmpresa($data, $idPuesto){
        $sql = "CALL sp_actualizar_puesto_empresa(?,?,?,?)";
        $types = "iiss"; // idEmpresa, idPuesto, nombre, descripcion

        $idEmpresa = $this->header['Business-Id'];

        $values = [
            $idPuesto,
            $idEmpresa,
            $this->nullOr($data['nombre'] ?? null),
            $this->nullOr($data['descripcion'] ?? null)
        ];

        return $this->executeProcedureUpdate($sql, $types, $values);
    }
    public function actualizarDepartamentoEmpresa($data, $idDepartamento){
        $sql = "CALL sp_actualizar_departamento_empresa(?,?,?,?)";
        $types = "iisi";
        $values = [
            $idDepartamento,
            $this->header['Business-Id'],
            $this->nullOr($data['nombre'] ?? null),
            $this->nullOr($data['id_departamento_padre'] ?? null, 'int')
        ];
        return $this->executeProcedureUpdate($sql, $types, $values);
    }
    public function eliminarPuestoTrabajoEmpresa($idPuesto){
        $sql = "CALL sp_eliminar_puesto_empresa(?, ?)";
        $types = "ii";
        $values = [
            $idPuesto,
            $this->header['Business-Id']
        ];
        return $this->executeProcedureDelete($sql, $types, $values);
    }
    public function eliminarDepartamentoEmpresa($idDepartamento){
        $sql = "CALL sp_eliminar_departamento_empresa(?, ?)";
        $types = "ii";
        $values = [
            $idDepartamento,
            $this->header['Business-Id']
        ];
        return $this->executeProcedureDelete($sql, $types, $values);
    }
    private function executeProcedureRead($sql, $types, $values) {
        $stmt = $this->mysqli->prepare($sql);
        if (!$stmt) {
            throw new Exception("E501 - Prepare failed: " . $this->mysqli->error);
        }
        $stmt->bind_param($types, ...$values);
        $stmt->execute();
        $result = $stmt->get_result();
        $rows = [];
        while ($row = $result->fetch_assoc()) {
            $rows[] = $row;
        }
        $result->free();
        $stmt->close();
        // Limpieza en caso de SPs
        while ($this->mysqli->more_results() && $this->mysqli->next_result()) {
            if ($res = $this->mysqli->use_result()) {
                $res->free();
            }
        }
        return $rows;
    }   
    private function executeProcedureUpdate($sql, $types, $values) {
        $this->mysqli->begin_transaction();
        try {
            $stmt = $this->mysqli->prepare($sql);
            if ($stmt === false) {
                throw new Exception("E501 - " . $this->mysqli->error);
            }
            $stmt->bind_param($types, ...$values);
            $stmt->execute();
            $result = $stmt->get_result();
            $filasAfectadas = 0;
            if ($result) {
                $row = $result->fetch_assoc();
                $filasAfectadas = (int)($row['registros_actualizados'] ?? 0);
                $result->free();
            }
            $stmt->close();
            $this->mysqli->commit();
            return $filasAfectadas;
        } catch (\Throwable $e) {
            $this->mysqli->rollback();
            throw new RuntimeException("MySQL error {$e->getCode()}: " . $e->getMessage(), (int)$e->getCode(), $e);
        }
    }   
    private function executeProcedureDelete($sql, $types, $values) {
        $this->mysqli->begin_transaction();
        try {
            $stmt = $this->mysqli->prepare($sql);
            if ($stmt === false) {
                throw new Exception("E501 - " . $this->mysqli->error);
            }
            $stmt->bind_param($types, ...$values);
            $stmt->execute();
            $result = $stmt->get_result();
            $filasAfectadas = 0;
            if ($result) {
                $row = $result->fetch_assoc();
                $filasAfectadas = (int)($row['registros_eliminados'] ?? 0);
                $result->free();
            }
            $stmt->close();
            $this->mysqli->commit();
            return $filasAfectadas;
        } catch (\Throwable $e) {
            $this->mysqli->rollback();
            throw new RuntimeException("MySQL error {$e->getCode()}: " . $e->getMessage(), (int)$e->getCode(), $e);
        }
    }
    private function executeProcedureCreate($sql, $types, $values) {
        $this->mysqli->begin_transaction();
        try {
            $stmt = $this->mysqli->prepare($sql);
            if ($stmt === false) {
                throw new Exception("E501 - " . $this->mysqli->error);
            }
            $stmt->bind_param($types, ...$values);
            $stmt->execute();
            // Obtener resultado si el SP hace un SELECT
            $result = $stmt->get_result();
            $nuevoId = null;
            if ($result) {
                $row = $result->fetch_assoc();
                $nuevoId = $row['id'] ?? null;
                $result->free();
            }
            $stmt->close();
            $this->mysqli->commit(); // ✅ COMMIT explícito
            return $nuevoId;
        } catch (\mysqli_sql_exception $e) {
            $this->mysqli->rollback(); // ❗ rollback si hay error
            throw new RuntimeException("MySQL error {$e->getCode()}: " . $e->getMessage(), (int)$e->getCode(), $e);
        } catch (\Throwable $th) {
            $this->mysqli->rollback();
            ApiResponse::error($th->getMessage());
        }
    }
    private function executeProcedureWithMultipleResults($sql, $types, $values) {
        $stmt = $this->mysqli->prepare($sql);
        if (!$stmt) {
            throw new Exception("E501 - Prepare failed: " . $this->mysqli->error);
        }

        $stmt->bind_param($types, ...$values);
        $stmt->execute();

        $results = [];

        do {
            // Obtener el result set actual
            $result = $stmt->get_result();
            $rows = [];

            if ($result) {
                while ($row = $result->fetch_assoc()) {
                    $rows[] = $row;
                }
                $result->free(); // ✅ Libera el buffer
            }

            $results[] = $rows;

        } while ($stmt->more_results() && $stmt->next_result());

        $stmt->close();
        return $results;
    }
    private function nullOr($value, $cast = null) {
        if (empty($value)) return null;
        return $cast === 'int' ? (int)$value : $value;
    }
}