<?php
class TemplateEvaluacion {
    private $mysqli;
    private $header;
    public function __construct($mysqli,$header){
        $this->mysqli = $mysqli;
        $this->mysqli->set_charset("utf8mb4");
        $this->header = $header;
    }
    /* --- funciones de obtencion de datos de las plantillas ---*/
    public function getResumen(){
        $sql = "CALL sp_resumen_plantillas();";
        $resp = $this->executeSelectQuery($sql);
        if($resp === false) $resp=[];
        return $resp;
    }
    public function getAllOrganizationType(){
        $sql = "SELECT id, tipo FROM __tipo_organizacion;";
        $resp = $this->executeSelectQuery($sql);
        if($resp === false) $resp=[];
        return $resp;
    }
    public function getAllTemplateType(){
        $sql = "SELECT id, tipo FROM __tipo_plantilla;";
        $resp = $this->executeSelectQuery($sql);
        if($resp === false) $resp=[];
        return $resp;
    }
    public function getTemplateTypeById($id){
        $sql = "SELECT id, tipo FROM __tipo_plantilla where id = ?;";
        $type = 'i';
        $values[] = $id;
        $resp = $this->executeSelectQuery($sql,$type,$values);
        return $resp;
    }
    public function getAllTemplate(){
        $sql = "SELECT tmp.id AS id_plantilla
            	, tmp.nombre AS nombre_plantilla
            	, tmp.descripcion AS descripcion_plantilla
            	, tmpo.id as id_tipo_organizacion
            	, tmpo.tipo as tipo_organizacion
            	, tmpp.id as id_tipo_plantilla
            	, tmpp.tipo as tipo_plantilla
            	, _prd.id AS id_dimension
            	, _prd.nombre AS nombre_dimension
            FROM __plantilla_rol tmp 
            left join __tipo_organizacion tmpo on tmp.id_tipo_organizacion = tmpo.id 
            left join __tipo_plantilla tmpp on tmp.id_tipo_plantilla = tmpp.id 
            LEFT JOIN __plantilla_rol_dimension _prd ON _prd.id_rol = tmp.id
            WHERE tmp.estado = 'ACTIVO' 
            	AND _prd.estado = 'ACTIVO'
            ORDER BY tmpo.tipo asc, tmp.nombre asc
        ;";
        $resp = $this->executeSelectQuery($sql);
        return $resp;
    }
    public function getAllTemplateByType($id){
        $sql = "SELECT tmp.id AS id_plantilla
            	, tmp.nombre AS nombre_plantilla
            	, tmp.descripcion AS descripcion_plantilla
            	, tmpo.id as id_tipo_organizacion
            	, tmpo.tipo as tipo_organizacion
            	, tmpp.id as id_tipo_plantilla
            	, tmpp.tipo as tipo_plantilla
            	, _prd.id AS id_dimension
            	, _prd.nombre AS nombre_dimension
            FROM __plantilla_rol tmp 
            left join __tipo_organizacion tmpo on tmp.id_tipo_organizacion = tmpo.id 
            left join __tipo_plantilla tmpp on tmp.id_tipo_plantilla = tmpp.id 
            LEFT JOIN __plantilla_rol_dimension _prd ON _prd.id_rol = tmp.id
            WHERE tmp.estado = 'ACTIVO' 
            	AND _prd.estado = 'ACTIVO'
                AND tmp.id_tipo_plantilla = ?
            ORDER BY tmp.nombre asc
        ;";
        $type = 'i';
        $values[] = $id;
        $resp = $this->executeSelectQuery($sql,$type,$values);
        if($resp === false) $resp=[];
        return $resp;
    }
    public function getTemplateById($id,$falg = false){
        if($falg) $where = "tmp.estado = 'ACTIVO' AND"; $where="";
        $sql = "SELECT tmp.id,tmp.nombre,tmp.descripcion,tmp.estado,tmpo.id as id_tipo_organizacion,tmpo.tipo as tipo_organizacion,tmpp.id as id_tipo_plantilla,tmpp.tipo as tipo_plantilla FROM __plantilla_rol tmp  left join __tipo_organizacion tmpo on tmp.id_tipo_organizacion = tmpo.id left join __tipo_plantilla tmpp on tmp.id_tipo_plantilla = tmpp.id WHERE ".$where." tmp.id = ? ORDER BY tmpo.tipo asc, tmp.nombre asc;";
        $type = 'i';
        $values[] = $id;
        $resp = $this->executeSelectQuery($sql,$type,$values);
        return $resp ?? false;
    }
    public function getDimensionByRoleId($id){
        $sql = "SELECT id,nombre AS dimension FROM __plantilla_rol_dimension WHERE id_rol=? ORDER BY dimension asc;";
        $type = 'i';
        $values[] = $id;
        $resp = $this->executeSelectQuery($sql,$type,$values);
        return $resp ?? false;
    }
    public function getSubDimension($data){
        $sql = "SELECT id,nombre AS subdimension FROM __plantilla_rol_subdimension WHERE id_rol=? and id_dimension=? ORDER BY subdimension asc;";
        $type = 'ii';
        $values[] = $data['rol'];
        $values[] = $data['dimension'];
        $resp = $this->executeSelectQuery($sql,$type,$values);
        return $resp ?? false;
    }
    public function getSubDimensionById($id){
        $sql = "SELECT id,nombre AS subdimension FROM __plantilla_rol_subdimension WHERE id=?;";
        $type = 'i';
        $values[] = $id;
        $resp = $this->executeSelectQuery($sql,$type,$values);
        return $resp ?? false;
    }
    public function getIndicadorDesempenoByDimension($id){
        $sql = "SELECT _pid.id AS id_indicador_desempeno
        	,_pid.nombre AS nombre_indicador_desempeno
        	,_pid.id_dimension AS id_dimension
        	,_pd.nombre AS nombre_dimension
        	,CASE WHEN _ps.estado = 'ELIMINADO' THEN NULL ELSE _pid.id_subdimension END AS id_subdimension
        	,CASE WHEN _ps.estado = 'ELIMINADO' THEN NULL ELSE _ps.nombre END AS nombre_subdimension
        	,_pid.id_rol AS id_evaluacion
        	,_pr.nombre AS nombre_evaluacion
            FROM __plantilla_rol_indicador_desempeno _pid
            LEFT JOIN __plantilla_rol_subdimension _ps ON _ps.id = _pid.id_subdimension
            LEFT JOIN __plantilla_rol_dimension _pd ON _pd.id = _pid.id_dimension
            LEFT JOIN __plantilla_rol _pr ON _pr.id = _pid.id_rol
            WHERE _pid.id_dimension = ?
            ORDER BY _pd.id ASC ,_ps.id asc
        ;";
        $type = 'i';
        $values = array($id);
        $resp = $this->executeSelectQuery($sql,$type,$values);
        return $resp ?? false;
    }
    public function getIndicadorDesempenoBySubdimension($id){
        $sql = "SELECT _pid.id AS id_indicador_desempeno
        	,_pid.nombre AS nombre_indicador_desempeno
        	,_pid.id_dimension AS id_dimension
        	,_pd.nombre AS nombre_dimension
        	,CASE WHEN _ps.estado = 'ELIMINADO' THEN NULL ELSE _pid.id_subdimension END AS id_subdimension
        	,CASE WHEN _ps.estado = 'ELIMINADO' THEN NULL ELSE _ps.nombre END AS nombre_subdimension
        	,_pid.id_rol AS id_evaluacion
        	,_pr.nombre AS nombre_evaluacion
            FROM __plantilla_rol_indicador_desempeno _pid
            LEFT JOIN __plantilla_rol_subdimension _ps ON _ps.id = _pid.id_subdimension
            LEFT JOIN __plantilla_rol_dimension _pd ON _pd.id = _pid.id_dimension
            LEFT JOIN __plantilla_rol _pr ON _pr.id = _pid.id_rol
            WHERE _pid.id_subdimension = ?
            ORDER BY _pd.id ASC ,_ps.id asc
        ;";
        $type = 'i';
        $values = array($id);
        $resp = $this->executeSelectQuery($sql,$type,$values);
        return $resp ?? false;
    }
    public function getIndicadorDesempenoByRol($id){
        $sql = "SELECT _pid.id AS id_indicador_desempeno
        	,_pid.nombre AS nombre_indicador_desempeno
        	,_pid.id_dimension AS id_dimension
        	,_pd.nombre AS nombre_dimension
        	,CASE WHEN _ps.estado = 'ELIMINADO' THEN NULL ELSE _pid.id_subdimension END AS id_subdimension
        	,CASE WHEN _ps.estado = 'ELIMINADO' THEN NULL ELSE _ps.nombre END AS nombre_subdimension
        	,_pid.id_rol AS id_evaluacion
        	,_pr.nombre AS nombre_evaluacion
            FROM __plantilla_rol_indicador_desempeno _pid
            LEFT JOIN __plantilla_rol_subdimension _ps ON _ps.id = _pid.id_subdimension
            LEFT JOIN __plantilla_rol_dimension _pd ON _pd.id = _pid.id_dimension
            LEFT JOIN __plantilla_rol _pr ON _pr.id = _pid.id_rol
            WHERE _pid.id_rol = ?
            ORDER BY _pd.id ASC ,_ps.id asc
        ;";
        $type = 'i';
        $values = array($id);
        $resp = $this->executeSelectQuery($sql,$type,$values);
        return $resp ?? false;
    }
    /* --- funciones de actualizacion de datos de las plantillas ---*/
    public function updateTemplateById($id, $data){
        $sql = "UPDATE __plantilla_rol SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre']) && $data['nombre'] !== '') {
            $sql .= "nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }
        if (isset($data['descripcion']) && $data['descripcion'] !== '') {
            $sql .= "descripcion = ?, ";
            $types .= "s";
            $values[] = $data['descripcion'];
        }
        if (isset($data['estado']) && $data['estado'] !== '') {
            $sql .= "estado = ?, ";
            $types .= "s";
            $values[] = $data['estado'];
        }
        if (isset($data['id_tipo_organizacion']) && $data['id_tipo_organizacion'] !== '') {
            $sql .= "id_tipo_organizacion = ?, ";
            $types .= "i";
            $values[] = $data['id_tipo_organizacion'];
        }
        if (isset($data['id_tipo_plantilla']) && $data['id_tipo_plantilla'] !== '') {
            $sql .= "id_tipo_plantilla = ?, ";
            $types .= "s";
            $values[] = $data['id_tipo_plantilla'];
        }      
        $types .= "i";
        $values[] = $id;
        $sql = rtrim($sql, ", "). " WHERE id = ?";

        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateDimensionById($id, $data){
        $sql = "UPDATE __plantilla_rol_dimension SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre']) && $data['nombre'] !== '') {
            $sql .= "nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }      
        $types .= "i";
        $values[] = $id;
        $sql = rtrim($sql, ", "). " WHERE id = ?";

        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateSubDimensionById($id, $data){
        $sql = "UPDATE __plantilla_rol_subdimension SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre']) && $data['nombre'] !== '') {
            $sql .= "nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }      
        $types .= "i";
        $values[] = $id;
        $sql = rtrim($sql, ", "). " WHERE id = ?";

        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    public function updateIndicadorDesempenoById($id, $data){
        $sql = "UPDATE __plantilla_rol_indicador_desempeno SET ";
        $params = [];
        $types = "";
        $values = [];
        if (isset($data['nombre']) && $data['nombre'] !== '') {
            $sql .= "nombre = ?, ";
            $types .= "s";
            $values[] = $data['nombre'];
        }      
        $types .= "i";
        $values[] = $id;
        $sql = rtrim($sql, ", "). " WHERE id = ?";

        $resp = $this->executeUpdateQuery($sql,$types,$values);
        return $resp;
    }
    /* --- funciones de eliminacion de datos de las plantillas ---*/
    public function deletePlantillaById($id){
        $sql = "DELETE FROM __plantilla_rol WHERE id=?;";
        $types ="i";
        $values[]=$id;
        $resp = $this->executeDeleteQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteDimensionById($id){
        $sql = "DELETE FROM __plantilla_rol_dimension WHERE id=?;";
        $types = "i";
        $values[]=$id;
        $resp = $this->executeDeleteQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteSubDimensionById($id){
        $sql = "DELETE FROM __plantilla_rol_subdimension WHERE id=?;";
        $types ="i";
        $values[]=$id;
        $resp = $this->executeDeleteQuery($sql,$types,$values);
        return $resp;
    }
    public function deleteIndicadorDesempenoById($id){
        $sql = "DELETE FROM __plantilla_rol_indicador_desempeno WHERE id=?;";
        $types ="i";
        $values[]=$id;
        $resp = $this->executeDeleteQuery($sql,$types,$values);
        return $resp;
    }
    
    /* --- funciones de creacion de datos de las plantillas ---*/
    public function saveRol($rol,$description,$typeOrganization,$typeTemplate){
        $sql = "insert into __plantilla_rol(nombre,descripcion,id_tipo_organizacion,id_tipo_plantilla) value (?,?,?,?);";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("ssii", $rol,$description,$typeOrganization,$typeTemplate);
        if (!$stmt->execute()) {
            throw new Exception("Error al crear: " . $stmt->error);
        }
        $id = $this->mysqli->insert_id;
        $stmt->close();
        return($id);
    }
    public function saveDimension($rol,$dimension){
        $sql = "insert into __plantilla_rol_dimension(nombre,id_rol) value (?,?);";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("si",$dimension,$rol);
        if (!$stmt->execute()) {
            throw new Exception("Error al crear: " . $stmt->error);
        }
        $id = $this->mysqli->insert_id;
        $stmt->close();
        return($id);
    }
    public function saveSubdimension($dimension,$subdimension,$rol){
        $sql = "insert into __plantilla_rol_subdimension(nombre,id_rol,id_dimension) value (?,?,?);";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("sii",$subdimension,$rol,$dimension);
        if (!$stmt->execute()) {
            throw new Exception("Error al crear: " . $stmt->error);
        }
        $id = $this->mysqli->insert_id;
        $stmt->close();
        return($id);
    }
    public function saveIndicatorWithoutSubdimension($dimension,$indicator,$rol){
        $sql = "insert into __plantilla_rol_indicador_desempeno(nombre,id_dimension,id_rol) value (?,?,?);";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("sii",$indicator,$dimension,$rol);
        if (!$stmt->execute()) {
            throw new Exception("Error al crear: " . $stmt->error);
        }
        $id = $this->mysqli->insert_id;
        $stmt->close();
        return($id);
    }
    public function saveIndicatorWithSubdimension($dimension,$indicator,$subdimension,$rol){
        $sql = "insert into __plantilla_rol_indicador_desempeno(nombre,id_dimension,id_subdimension,id_rol) value (?,?,?,?);";
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("Error al preparar la consulta: " . $this->mysqli->error);
        }
        $stmt->bind_param("siii",$indicator,$dimension,$subdimension,$rol);
        if (!$stmt->execute()) {
            throw new Exception("Error al crear: " . $stmt->error);
        }
        $id = $this->mysqli->insert_id;
        $stmt->close();
        return($id);
    }

    /* --- funciones de ejecucion de consultas ---*/
    private function executeSelectQuery($sql,$type = '',$values = []){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        if($type != '') $stmt->bind_param($type, ...$values);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $resp[] = $row;
        }
        $stmt->close();
        return $resp ?? false;
    }
        private function executeUpdateQuery($sql,$types = '',$values = []){
            $stmt = $this->mysqli->prepare($sql);
            if ($stmt === false) {
                throw new Exception("E501", $this->mysqli->error);
            }
            if($types != '') $stmt->bind_param($types, ...$values);
            if (!$stmt->execute()) {
                throw new Exception('E502');
            }
            $affected_rows = $stmt->affected_rows;
            $info = $this->mysqli->info;
            $matched = null;
            if (preg_match('/Rows matched:\s*(\d+)/', $info, $m)) {
            $matched = (int)$m[1];
            }
            $stmt->close();
            $outp = array("m" => $affected_rows , "c"=> $matched);

            return $outp;
        }
    private function executeDeleteQuery($sql,$types = '',$values = []){
        $stmt = $this->mysqli->prepare($sql);
        if ($stmt === false) {
            throw new Exception("E501", $this->mysqli->error);
        }
        if($types != '') $stmt->bind_param($types, ...$values);
        if (!$stmt->execute()) {
            throw new Exception('E502');
        }
        $affected_rows = $stmt->affected_rows;
        $stmt->close();
        $outp = array("m" => $affected_rows);

        return $outp;
    }
}
?>