<?php
require_once 'controllers/TemplateEvaluacionController.php';
require_once 'utils/ValidateRequestField.php';

class Router {
    private $controller;
    private $method;
    private $uri;
    private $id;
    private $typeResource;
    private $stage;

    public function __construct($mysqli,$header) {
        $this->method = $_SERVER['REQUEST_METHOD'];
        $this->uri = $_SERVER['REQUEST_URI'];
        $partes = array_filter(explode('/', rtrim($this->uri, '/')));
        $resource = isset($partes[3]) ? $partes[3] : '';
        //$stage = isset($partes[4]) ? $partes[4] : '';
        $this->typeResource = $resource;
        //$this->stage = $stage;
        $this->id = isset($partes[4]) && is_numeric($partes[4]) ? (int)$partes[4] : null;
        $this->controller = new TemplateEvaluacionController($mysqli,$header);
    }

    public function route($header) {
        switch ($this->method) {
            case 'GET':
                switch($this->typeResource){
                    case 'resumen':
                        $this->controller->getResumen();
                        break;
                    case 'listar-tipo-organizacion':
                        $this->controller->getOrganizationType();
                        break;
                    case 'listar-tipo-plantilla':
                        $this->controller->getTemplateType();
                        break;
                    case 'plantillas':
                        if ($this->id) $this->controller->getTemplateTypeById($this->id); $this->controller->getAllTemplate();
                        break;
                    case 'plantilla':
                        if ($this->id) $this->controller->getTemplateById($this->id); ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                    case 'dimension':
                        if ($this->id) $this->controller->getDimensionByRoleId($this->id); ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                    case 'subdimension':
                        if ($this->id) $this->controller->getSubdimensionById($this->id);

                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                        if($error = ValidateRequest::validateGetSubdimensionField($data)) ApiResponse::error('E400',$error);
                        $this->controller->getSubdimension($data);
                        break;
                    case 'indicador-desempeno-dimension':
                        if ($this->id) $this->controller->getIndicadorDesempenoByDimension($this->id); ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                    case 'indicador-desempeno-subdimension':
                        if ($this->id) $this->controller->getIndicadorDesempenoBySubdimension($this->id); ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                    case 'indicador-desempeno-rol':
                        if ($this->id) $this->controller->getIndicadorDesempenoByRol($this->id); ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'POST':
                switch ($this->typeResource) {
                    case 'crear-plantilla':
                        $data = $_REQUEST;
                        if($error = ValidateRequest::validateData($data)) ApiResponse::error('E400',$error);
                        $file = $_FILES;
                        if($error = ValidateRequest::validateField($file)) ApiResponse::error('E400',$error);
                        $this->controller->createTemplate($data,$file);
                        break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'PATCH':
                if (!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                $input = file_get_contents('php://input');
                $data = json_decode($input, true);
                if(!$data) ApiResponse::error('E400','JSON no provisto o invalido');
                switch ($this->typeResource) {
                    case 'plantilla':
                        if($error = ValidateRequest::validateUpdatePlantillaField($data)) ApiResponse::error('E400',$error);
                        $this->controller->updateTemplateById($this->id, $data);
                        break;
                    case 'dimension':
                        if($error = ValidateRequest::validateUpdateDimensionField($data)) ApiResponse::error('E400',$error);
                        $this->controller->updateDimensionById($this->id, $data);
                        break;
                    case 'subdimension':
                        if($error = ValidateRequest::validateUpdateSubDimensionField($data)) ApiResponse::error('E400',$error);
                        $this->controller->updateSubDimensionById($this->id, $data);
                        break;
                    case 'indicador-desempeno':
                        if($error = ValidateRequest::validateUpdateIndicadorDesempenoField($data)) ApiResponse::error('E400',$error);
                        $this->controller->updateIndicadorDesempenoById($this->id, $data);
                        break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'DELETE':
                if (!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                switch ($this->typeResource) {
                    case 'plantilla':
                        $this->controller->deletePlantillaById($this->id);
                        break;
                    case 'dimension':
                        $this->controller->deleteDimensionById($this->id);
                        break;
                    case 'subdimension':
                        $this->controller->deleteSubDimensionById($this->id);
                        break;
                    case 'indicador-desempeno':
                        $this->controller->deleteIndicadorDesempenoById($this->id);
                        break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            default:
                ApiResponse::error('E001');
                break;
        }
    }
}
?>