<?php
require_once 'controllers/ProfileController.php';
require_once 'utils/ValidateFieldRule.php';
class Router {
    private $controller;
    private $method;
    private $uri;
    private $id;
    private $typeResource;


    public function __construct($mysqli,$header) {
        $this->method = $_SERVER['REQUEST_METHOD'];
        $this->uri = $_SERVER['REQUEST_URI'];
        $partes = array_filter(explode('/', rtrim($this->uri, '/')));
        $resource = isset($partes[3]) ? $partes[3] : '';
        $this->typeResource = $resource;
        $this->id = isset($partes[4]) && is_numeric($partes[4]) ? (int)$partes[4] : null;
        $this->controller = new ProfileController($mysqli,$header);
    }

    public function route($header) {
        switch ($this->method) {
            case 'GET':
                switch($this->typeResource){
                    case 'listar-usuarios':
                        $this->controller->getAllUser();
                        break;
                    case 'resumen-usuarios':
                        $this->controller->resumenUser();
                        break;
                    case 'listar-perfiles':
                        $this->controller->getAllProfile();
                        break;
                    case 'listar-empresas':
                        $this->controller->listActiveBusiness();
                        break;
                    case 'listar-usuario':
                        if(!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        $this->controller->getUserById($this->id);
                        break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            case 'POST':
                switch($this->typeResource){
                    case 'crear-usuarios':
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        // manejo de error para la creacion de evaluaciones cuando el body no es provisto
                        if (!$data) ApiResponse::error('E003','JSON no provisto o inválido');
                        if($error = ValidateData::validateCreateUser($data)) ApiResponse::Error('E003',$error);
                        $this->controller->createUser($data);
                    break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;

            case 'PATCH':
                switch ($this->typeResource) {
                    case 'actualizar-usuario':
                        if(!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        $input = file_get_contents('php://input');
                        $data = json_decode($input, true);
                        if (!$data) ApiResponse::error('E003','JSON no provisto o inválido');
                        if($error = ValidateData::validateUpdateUser($data)) ApiResponse::Error('E003',$error);
                        $this->controller->updateUser($this->id,$data);
                        break;
                    case 'bloquear-usuario':
                        if(!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        $this->controller->bloquearUsuario($this->id);
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;    
            case 'DELETE':
                switch ($this->typeResource) {
                    case 'eliminar-usuario':
                        if(!$this->id) ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        $this->controller->deleteUser($this->id);
                        break;
                    default:
                        ApiResponse::error('E002','Recurso '.$this->typeResource.' no encontrado');
                        break;
                }
                break;
            default:
                ApiResponse::error('E001');
                break;
        }
    }
}
?>