<?php
require_once __DIR__ . '/../models/Region.php';
class RegionController {
    private $profileModel;
    private $dataErrors = [];
    private $header;
    
    public function __construct($mysqli,$header) {
        $this->regionModel = new Region($mysqli,$header);
        $this->header = $header;
    }

    public function getRegion(){
        try{
            $region = $this->regionModel->getAllRegion();
            ApiResponse::success('S001',$region);
        } catch (Exception $e){
            ApiResponse::error($e->getMessage());
        }
    }
    public function getProvincias($id){
        try{
            $provincias = $this->regionModel->getProvinciasByIdRegion($id);
            if(!$provincias) throw new Exception('E002');
            ApiResponse::success('S001',$provincias);
        } catch (Exception $e){
            ApiResponse::error($e->getMessage());
        }
    }
    public function getComunas($id){
        try{
            $comunas = $this->regionModel->getComunaByIdProvincias($id);
            if(!$comunas) throw new Exception('E002');
            ApiResponse::success('S001',$comunas);
        } catch (Exception $e){
            ApiResponse::error($e->getMessage());
        }
    }
    public function createUser($data) {
        try{
            $hashCalculado = hash('sha256', $data['contrasena']);
            if ($hashCalculado != $data['hash_auth']) $dataErrors[] = "EL hash_auth provisto no es valido";

            if(isset($dataErrors)) ApiResponse::error('E011',$dataErrors);// valida si hay error asociado al segundo nivel de validacion de parametros.
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    $idUser = $this->profileUserModel->createUser($data['nombre'], $data['apellido_1'], $data['apellido_2'], $data['email'], $data['nombre_usuario'], $data['contrasena'], $data['hash_auth'], $data['id_empresa']);
                    $this->profileUserModel->createUserProfile($idUser,$data['tipo_perfil']);
                    ApiResponse::success('S002',$idUser);
                    break;
                case 'ADMIN':
                    if($this->header['Business-Id']==$data['id_empresa']){
                        $idUser = $this->profileUserModel->createUser($data['nombre'], $data['apellido_1'], $data['apellido_2'], $data['email'], $data['nombre_usuario'], $data['contrasena'], $data['hash_auth'], $data['id_empresa']);
                        $this->profileUserModel->createUserProfile($idUser,$data['tipo_perfil']);
                        ApiResponse::success('S002',$idUser);
                    }else{
                        throw new Exception('E004');
                    }
                    break;
                default:
                    throw new Exception('E004');
                    break;
            }
            
        } catch(Exception $e){
             ApiResponse::error($e->getMessage());
        }
    }
    public function getAllProfile(){
        try{
            switch($this->header['profile']){
                case 'SUPERADMIN':
                    $profiles = $this->profileUserModel->getAllProfile();
                    break;
                case 'ADMIN':
                    $profiles = $this->profileUserModel->getAdminProfiles();
                    break;
                default:
                    throw new Exception('E004');
                    break;       
            }
            if($profiles) ApiResponse::success('S001',$profiles); throw new Exception('E012');
        }catch(Exception $e){
             ApiResponse::error($e->getMessage());
        }
    }
    public function listActiveBusiness(){
        try {
            switch($this->header['profile']){
                case 'SUPERADMIN':
                    $business = $this->profileUserModel->getListBusinessActive();
                    if ($business) $response = ApiResponse::success('S001',$business);  throw new Exception('E012');
                    break;
                default:
                    throw new Exception('E004');
                    break;       
            }        
        } catch (Exception $e) {
             ApiResponse::error($e->getMessage());
        }
    }
    public function updateUser($id,$data){
        try {
            $modParam['nombre'] = NULL;
            $modParam['apellido_1'] = NULL;
            $modParam['apellido_2'] = NULL;
            $modParam['email'] = NULL;
            $modParam['contrasena'] = NULL;
            $modParam['hash_auth'] = NULL;
            $modParam['estado'] = null;

            if(isset($data['contrasena']) && isset($data['hash_auth'])){
                $hashCalculado = hash('sha256', $data['contrasena']);
                if ($hashCalculado != $data['hash_auth']) {
                    $dataErrors[] = "EL hash_auth provisto no es valido";
                }else{
                    $modParam['contrasena'] = $data['contrasena'];
                    $modParam['hash_auth'] = $data['hash_auth'];
                }
            }
            if(isset($data['email'])) $modParam['email'] = $data['email'];
            if(isset($data['nombre'])) $modParam['nombre'] = $data['nombre'];
            if(isset($data['apellido_1'])) $modParam['apellido_1'] = $data['apellido_1'];
            if(isset($data['apellido_2'])) $modParam['apellido_2'] = $data['apellido_2'];
            if(isset($data['estado'])) $modParam['estado'] = $data['estado'];
            if(isset($dataErrors)) ApiResponse::error('E011',$dataErrors);// valida si hay error asociado al segundo nivel de validacion de parametros.

            $affected_rows = 0;
            switch($this->header['profile']){
                case 'SUPERADMIN':
                    $affected_rows = $this->profileUserModel->updateUserById($id,$modParam); // actualiza el usuario solicitado, no se valida la empresa que realiza la solicitud dado que el SUPERADMIN controla todas las organizaciones del sistema.
                    break;
                case 'ADMIN':
                    if($this->header['User-Id'] == $id){
                       $affected_rows = $this->profileUserModel->updateUserById($id,$modParam);
                    }else{
                        $userUpdate = $this->profileUserModel->getUserById($id,$this->header['Business-Id']); // valida si el usuario a actualizar corresponde a la empresa que solicita la actualización.
                        if(!$userUpdate) throw new Exception('E005');
                        $affected_rows = $this->profileUserModel->updateUserById($id,$modParam);
                    }
                    break;
                default:
                    if($this->header['User-Id'] == $id){
                        $affected_rows = $this->profileUserModel->updateUserById($id,$modParam);
                    }else{
                        throw new Exception('E004');
                    }
                    break;
            }
            if ($affected_rows > 0) ApiResponse::success('S003'); throw new Exception('E007');
        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
        
    }
    public function deleteUser($id){
        try {
            switch ($this->header['profile']) {
                case 'SUPERADMIN':
                    if($this->header['User-Id'] == $id) throw new Exception('E009');
                    $affected_rows = $this->profileUserModel->deleteUser($id);
                    if ($affected_rows > 0) {
                        ApiResponse::success('S004');
                    } else {
                        throw new Exception('E006');
                    }
                    break;
                case 'ADMIN':
                    if($this->header['User-Id'] == $id) throw new Exception('E009');
                    $userDelete = $this->profileUserModel->getUserById($id,$this->header['Business-Id']); // valida si el usuario a actualizar corresponde a la empresa que solicita la actualización.

                    if(!$userDelete) throw new Exception('E006');
                    if($userDelete[0]['tipo']=='ADMIN' || $userDelete[0]['tipo']=="SUPERADMIN") throw new Exception('E008');
                    $affected_rows = $this->profileUserModel->deleteUser($id);
                    if ($affected_rows > 0) {
                        ApiResponse::success('S004');
                    } else {
                        throw new Exception('E006');
                    }
                    break;
                default:
                    throw new Exception('E004');
                    break;
            }

        } catch (Exception $e) {
            ApiResponse::error($e->getMessage());
        }
    }
}

?>